/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.admin;

import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilter;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterConditionalExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterFunctionCall;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterRelationExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchStep;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizedMessage;
import com.ibm.cognos.camaaa.internal.ldap.admin.LdapQuery;
import com.ibm.cognos.camaaa.internal.ldap.admin.MultipleQuery;
import com.ibm.cognos.camaaa.internal.ldap.admin.ObjectTypeDeterminer;
import com.ibm.cognos.camaaa.internal.ldap.admin.SimpleQuery;
import com.ibm.cognos.camaaa.internal.ldap.admin.SimpleQueryUsingDN;
import com.ibm.cognos.camaaa.internal.ldap.admin.exception.SimplificationException;
import com.ibm.cognos.camaaa.internal.ldap.admin.exception.SyntaxErrorException;
import com.ibm.cognos.camaaa.internal.ldap.auth.LDAPVisa;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapUtil;
import com.ibm.cognos.camaaa.internal.ldap.common.NamespaceConfiguration;
import java.util.Map;

public class LdapQueryOptimizer {
    protected static final String WILDCARD = "*";
    protected static final String TILDE = "~";
    private static final String ACTOR = LdapQueryOptimizer.class.getName();
    private static final String PROPERTY_PREFIX = "@";
    private static final String AND_EXPRESSION_PREFIX = "(&";
    private static final String OR_EXPRESSION_PREFIX = "(|";
    private static final String END_EXPRESSION = ")";
    private static final String CONFIG_STRING_DELIMITER = ",";
    private static final String EQUAL_EXPRESSION = "=";
    private final NamespaceConfiguration namespaceConfiguration;
    private final String objectClass;
    private final String objectTypeID;

    public LdapQueryOptimizer(NamespaceConfiguration theNamespaceConfiguration, String theObjectClass) {
        this.namespaceConfiguration = theNamespaceConfiguration;
        this.objectClass = theObjectClass;
        this.objectTypeID = ObjectTypeDeterminer.getObjectTypeIdentifier(theObjectClass) + ":";
    }

    private LdapQuery createSimpleQuery(String theObjectID, int theScope, String theSearchFilter, String[] theProperties, boolean isUsingDn) throws LocalizableException {
        if (isUsingDn && theObjectID != null) {
            return this.createSimpleQueryUsingDn(theObjectID, theScope, theSearchFilter, theProperties);
        }
        return this.createSimpleQueryUsingObjectID(theObjectID, theScope, theSearchFilter, theProperties);
    }

    private LdapQuery createSimpleQueryUsingDn(String theStartDn, int theScope, String theSearchFilter, String[] theProperties) throws LocalizableException {
        String baseDn = theStartDn;
        if (baseDn.startsWith(this.objectTypeID)) {
            baseDn = baseDn.substring(this.objectTypeID.length());
        }
        return new SimpleQueryUsingDN(baseDn, this.namespaceConfiguration, this.objectClass, theScope, theSearchFilter, theProperties);
    }

    private LdapQuery createSimpleQueryUsingObjectID(String theObjectID, int theScope, String theSearchFilter, String[] theProperties) throws LocalizableException {
        return new SimpleQuery(this.namespaceConfiguration, this.objectClass, theScope, theSearchFilter, theProperties);
    }

    private String getAndExpression(SearchFilter[] theFilters) throws SyntaxErrorException, SimplificationException {
        StringBuffer buffer = new StringBuffer();
        int nbExpression = 0;
        for (int i = 0; i < theFilters.length; ++i) {
            try {
                buffer.append(this.getPredicate(theFilters[i]));
                ++nbExpression;
                continue;
            }
            catch (SimplificationException e) {
                if (e.getSimplifiedBooleanExpression()) continue;
                throw e;
            }
        }
        switch (nbExpression) {
            case 0: {
                throw new SimplificationException(true, (LocalizableMessage)new LocalizedMessage("Empty 'and' expression."));
            }
            case 1: {
                return buffer.toString();
            }
        }
        return AND_EXPRESSION_PREFIX + buffer.toString() + END_EXPRESSION;
    }

    private String getConditionalExpression(SearchFilterConditionalExpression theExpression) throws SyntaxErrorException, SimplificationException {
        if (theExpression.getOperator().equals("and")) {
            return this.getAndExpression(theExpression.getFilters());
        }
        if (theExpression.getOperator().equals("or")) {
            return this.getOrExpression(theExpression.getFilters());
        }
        throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("Invalid conditional expression operator."));
    }

    private String getContainsExpression(String[] parameters) throws SyntaxErrorException, SimplificationException {
        StringBuffer buffer = new StringBuffer();
        if (parameters.length != 2) {
            throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("The contains() function requires 2 parameters."));
        }
        String name = null;
        String value = null;
        if (parameters[0].startsWith(PROPERTY_PREFIX)) {
            name = parameters[0].substring(PROPERTY_PREFIX.length());
            value = parameters[1];
        } else if (parameters[1].startsWith(PROPERTY_PREFIX)) {
            name = parameters[1].substring(PROPERTY_PREFIX.length());
            value = parameters[0];
        } else {
            throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("The contains function requires a property as a parameter."));
        }
        String ldapAttribute = this.getLdapAttribute(name);
        if (ldapAttribute == null) {
            this.throwPropertyNotSupported(name);
        }
        buffer.append(this.getLdapEquals(ldapAttribute, this.getLdapStartsWithValue(this.getLdapEndsWithValue(value))));
        return buffer.toString();
    }

    private String getEndsWithExpression(String[] parameters) throws SyntaxErrorException, SimplificationException {
        StringBuffer buffer = new StringBuffer();
        if (parameters.length != 2) {
            throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("The ends-with function requires 2 parameters."));
        }
        String name = null;
        String value = null;
        if (parameters[0].startsWith(PROPERTY_PREFIX)) {
            name = parameters[0].substring(PROPERTY_PREFIX.length());
            value = parameters[1];
        } else if (parameters[1].startsWith(PROPERTY_PREFIX)) {
            name = parameters[1].substring(PROPERTY_PREFIX.length());
            value = parameters[0];
        } else {
            throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("The ends-with function requires a property as a parameter."));
        }
        String ldapAttribute = this.getLdapAttribute(name);
        if (ldapAttribute == null) {
            this.throwPropertyNotSupported(name);
        }
        buffer.append(this.getLdapEquals(ldapAttribute, this.getLdapEndsWithValue(value)));
        return buffer.toString();
    }

    private String getFilter(SearchFilter theSearchFilter) throws SyntaxErrorException, SimplificationException {
        String retval;
        block4: {
            retval = this.namespaceConfiguration.getObjectClassFilter(this.objectClass);
            if (theSearchFilter != null) {
                StringBuffer buffer = new StringBuffer();
                try {
                    String predicate = this.getPredicate(theSearchFilter);
                    if (predicate != null) {
                        buffer.append(AND_EXPRESSION_PREFIX);
                        buffer.append(this.getPredicate(theSearchFilter));
                        buffer.append(retval);
                        buffer.append(END_EXPRESSION);
                        retval = buffer.toString();
                    }
                }
                catch (SimplificationException e) {
                    if (e.getSimplifiedBooleanExpression()) break block4;
                    throw e;
                }
            }
        }
        return retval;
    }

    private String getFuntionCallExpression(SearchFilterFunctionCall theExpression) throws SyntaxErrorException, SimplificationException {
        StringBuffer buffer = new StringBuffer();
        String[] parameters = theExpression.getParameters();
        buffer.append('(');
        if (theExpression.getFunctionName().equals("CAMID") && parameters.length == 2) {
            String objectID = parameters[1];
            if (objectID == null) {
                throw new SimplificationException(false, (LocalizableMessage)new LocalizedMessage("Search for namespace."));
            }
            String searchableObjectID = objectID.substring(2);
            if (this.isCamidUsingObjectGuid()) {
                searchableObjectID = LdapUtil.searchableHexString(objectID.substring(2));
            }
            if (!this.isCamidUsingDn()) {
                buffer.append(this.getObjectIdFilter(searchableObjectID));
            }
        } else if (theExpression.getFunctionName().equals("contains")) {
            buffer.append(this.getContainsExpression(theExpression.getParameters()));
        } else if (theExpression.getFunctionName().equals("ends-with")) {
            buffer.append(this.getEndsWithExpression(theExpression.getParameters()));
        } else if (theExpression.getFunctionName().equals("starts-with")) {
            buffer.append(this.getStartsWithExpression(theExpression.getParameters()));
        } else {
            throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("Invalid function call."));
        }
        if (buffer.length() == 1) {
            return null;
        }
        buffer.append(')');
        return buffer.toString();
    }

    private String getLdapAttribute(String thePropertyName) {
        Map mapping = this.namespaceConfiguration.getObjectPropertyMappings(this.objectClass);
        if (mapping != null) {
            return (String)mapping.get(thePropertyName);
        }
        return null;
    }

    private String getLdapEndsWithValue(String theValue) {
        return WILDCARD + theValue;
    }

    private String getLdapEquals(String theAttribute, String theValue) {
        String configuredAttributes = theAttribute;
        String[] tokens = configuredAttributes.split(CONFIG_STRING_DELIMITER);
        if (tokens.length == 1) {
            return theAttribute + EQUAL_EXPRESSION + theValue;
        }
        String theAttributeValue = OR_EXPRESSION_PREFIX;
        for (int i = 0; i < tokens.length; ++i) {
            theAttributeValue = theAttributeValue + "(" + tokens[i].trim() + EQUAL_EXPRESSION + theValue + END_EXPRESSION;
        }
        theAttributeValue = theAttributeValue + END_EXPRESSION;
        return theAttributeValue;
    }

    private String getLdapStartsWithValue(String theValue) {
        return theValue + WILDCARD;
    }

    private String[] getNodeTestFilters(SearchStep theStep) {
        String[] retval = null;
        String nodeTest = theStep.getNodeTest();
        if (nodeTest.equals(WILDCARD) || nodeTest.equals(this.objectClass) || nodeTest.equals(TILDE) && this.objectClass.equals("account")) {
            retval = new String[]{this.namespaceConfiguration.getObjectClassFilter(this.objectClass)};
        }
        return retval;
    }

    private String getObjectID(SearchStep theStep) {
        String retval = null;
        SearchFilter searchFilter = theStep.getPredicate();
        if (searchFilter != null && searchFilter.getSearchFilterType() == 2) {
            SearchFilterFunctionCall function = (SearchFilterFunctionCall)theStep.getPredicate();
            String[] parameters = function.getParameters();
            if (function.getFunctionName().equals("CAMID") && parameters.length == 2) {
                retval = parameters[1];
            }
        }
        return retval;
    }

    private String getObjectIdFilter(String theObjectID) {
        if (theObjectID == null) {
            return null;
        }
        return this.getLdapEquals(this.namespaceConfiguration.getCAMIDAttribute(), theObjectID);
    }

    private String getOrExpression(SearchFilter[] theFilters) throws SyntaxErrorException, SimplificationException {
        boolean simplifiedValue = false;
        StringBuffer buffer = new StringBuffer();
        int nbExpression = 0;
        for (int i = 0; i < theFilters.length; ++i) {
            try {
                buffer.append(this.getPredicate(theFilters[i]));
                ++nbExpression;
                continue;
            }
            catch (SimplificationException e) {
                if (!e.getSimplifiedBooleanExpression()) continue;
                simplifiedValue = true;
            }
        }
        switch (nbExpression) {
            case 0: {
                throw new SimplificationException(simplifiedValue, (LocalizableMessage)new LocalizedMessage("Empty expression."));
            }
            case 1: {
                return buffer.toString();
            }
        }
        return OR_EXPRESSION_PREFIX + buffer.toString() + END_EXPRESSION;
    }

    private String getPredicate(SearchFilter theSearchFilter) throws SyntaxErrorException, SimplificationException {
        String predicate = null;
        switch (theSearchFilter.getSearchFilterType()) {
            case 3: {
                predicate = this.getConditionalExpression((SearchFilterConditionalExpression)theSearchFilter);
                break;
            }
            case 2: {
                predicate = this.getFuntionCallExpression((SearchFilterFunctionCall)theSearchFilter);
                break;
            }
            case 1: {
                predicate = this.getRelationalExpression((SearchFilterRelationExpression)theSearchFilter);
                break;
            }
            default: {
                throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("Invalid search filter type."));
            }
        }
        return predicate;
    }

    private LdapQuery getQueryForStep(String theStartObjectID, LDAPVisa theLdapVisa, SearchStep theStep, String[] theProperties, boolean isUsingDN) throws LocalizableException {
        LdapQuery ldapQuery = null;
        String[] nodeTestFilters = this.getNodeTestFilters(theStep);
        if (nodeTestFilters != null && nodeTestFilters.length > 0) {
            try {
                String ldapFilter = this.getFilter(theStep.getPredicate());
                int axis = theStep.getAxis();
                if (axis == 5 && theStartObjectID != null) {
                    if (theStartObjectID.startsWith(this.objectTypeID)) {
                        axis = 4;
                    } else {
                        return null;
                    }
                }
                switch (axis) {
                    case 3: {
                        ldapQuery = this.createSimpleQuery(theStartObjectID, 1, ldapFilter, theProperties, isUsingDN);
                        break;
                    }
                    case 4: {
                        ldapQuery = this.createSimpleQuery(theStartObjectID, 2, ldapFilter, theProperties, isUsingDN);
                        break;
                    }
                    case 5: {
                        LdapQuery[] queries = new LdapQuery[]{this.createSimpleQuery(theStartObjectID, 0, ldapFilter, theProperties, isUsingDN), this.createSimpleQuery(theStartObjectID, 2, ldapFilter, theProperties, isUsingDN)};
                        ldapQuery = new MultipleQuery(queries);
                        break;
                    }
                    case 7: {
                        ldapQuery = this.createSimpleQuery(theStartObjectID, 0, ldapFilter, theProperties, isUsingDN);
                        break;
                    }
                    default: {
                        throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("Invalid axis specified."));
                    }
                }
            }
            catch (SimplificationException simplificationException) {
                // empty catch block
            }
        }
        return ldapQuery;
    }

    private String getRelationalExpression(SearchFilterRelationExpression theExpression) throws SyntaxErrorException, SimplificationException {
        String ldapAttribute;
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        String propertyName = theExpression.getPropertyName().substring(PROPERTY_PREFIX.length());
        if (propertyName.equalsIgnoreCase("objectClass")) {
            this.simplifyObjecClassExpression(theExpression.getOperator(), theExpression.getConstraint());
        }
        if ((ldapAttribute = this.getLdapAttribute(propertyName)) == null) {
            this.throwPropertyNotSupported(propertyName);
        }
        buffer.append(ldapAttribute);
        buffer.append(theExpression.getOperator());
        buffer.append(theExpression.getConstraint());
        buffer.append(')');
        return buffer.toString();
    }

    private String getStartsWithExpression(String[] parameters) throws SyntaxErrorException, SimplificationException {
        StringBuffer buffer = new StringBuffer();
        if (parameters.length != 2) {
            throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("The starts-with function requires 2 parameters."));
        }
        String name = null;
        String value = null;
        if (parameters[0].startsWith(PROPERTY_PREFIX)) {
            name = parameters[0].substring(PROPERTY_PREFIX.length());
            value = parameters[1];
        } else if (parameters[1].startsWith(PROPERTY_PREFIX)) {
            name = parameters[1].substring(PROPERTY_PREFIX.length());
            value = parameters[0];
        } else {
            throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("The starts-with function requires a property as a parameter."));
        }
        String ldapAttribute = this.getLdapAttribute(name);
        if (ldapAttribute == null) {
            this.throwPropertyNotSupported(name);
        }
        buffer.append(this.getLdapEquals(ldapAttribute, this.getLdapStartsWithValue(value)));
        return buffer.toString();
    }

    private boolean isCamidUsingDn() {
        return this.namespaceConfiguration.getCAMIDAttribute().equals("dn");
    }

    private boolean isCamidUsingObjectGuid() {
        return this.namespaceConfiguration.getCAMIDAttribute().equalsIgnoreCase("objectGUID");
    }

    public LdapQuery run(LDAPVisa theLdapVisa, SearchStep theSearchStep, String[] theProperties) throws LocalizableException {
        boolean isUsingDN = this.isCamidUsingDn();
        if (theSearchStep == null) {
            return null;
        }
        return this.getQueryForStep(this.getObjectID(theSearchStep), theLdapVisa, theSearchStep, theProperties, isUsingDN);
    }

    private void simplifyObjecClassExpression(String theOperator, String theConstraint) throws SyntaxErrorException, SimplificationException {
        boolean simplifiedExpression = false;
        if (theOperator.equals(EQUAL_EXPRESSION)) {
            simplifiedExpression = theConstraint.equals(this.objectClass);
        } else if (theOperator.equals(">")) {
            simplifiedExpression = theConstraint.compareTo(this.objectClass) > 0;
        } else if (theOperator.equals(">=")) {
            simplifiedExpression = theConstraint.compareTo(this.objectClass) >= 0;
        } else if (theOperator.equals("<")) {
            simplifiedExpression = theConstraint.compareTo(this.objectClass) < 0;
        } else if (theOperator.equals("<=")) {
            simplifiedExpression = theConstraint.compareTo(this.objectClass) <= 0;
        } else if (theOperator.equals("!=")) {
            simplifiedExpression = !theConstraint.equals(this.objectClass);
        } else {
            throw new SyntaxErrorException(ACTOR, (LocalizableMessage)new LocalizedMessage("Invalid operator."));
        }
        throw new SimplificationException(simplifiedExpression, (LocalizableMessage)new LocalizedMessage("Simplification based on objectclass."));
    }

    private void throwPropertyNotSupported(String thePropertyName) throws SimplificationException {
        throw new SimplificationException(true, (LocalizableMessage)new LocalizedMessage("The property " + thePropertyName + " is not supported."));
    }
}

