/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;

public class ObjectTypeDeterminer {
    private final Map objectClassToObjectTypeMap = new HashMap();

    public ObjectTypeDeterminer(String[] theAccountObjectClasses, String[] theGroupObjectClasses, String[] theFolderObjectClasses, String[] theDistributionListObjectClasses) {
        this.populateMap(theAccountObjectClasses, "account");
        this.populateMap(theGroupObjectClasses, "group");
        this.populateMap(theFolderObjectClasses, "namespaceFolder");
        this.populateMap(theDistributionListObjectClasses, "distributionList");
    }

    public static char getObjectTypeIdentifier(String theObjectType) {
        int objectType = 63;
        if (theObjectType != null) {
            if (theObjectType.equals("account")) {
                objectType = 117;
            } else if (theObjectType.equals("group")) {
                objectType = 103;
            } else if (theObjectType.equals("namespaceFolder")) {
                objectType = 102;
            } else if (theObjectType.equals("distributionList")) {
                objectType = 100;
            }
        }
        return (char)objectType;
    }

    public String getObjectType(SearchResult theSearchResult) throws NamingException {
        Attribute objectObjectClass = theSearchResult.getAttributes().get("objectclass");
        NamingEnumeration<?> attrValues = objectObjectClass.getAll();
        while (attrValues.hasMore()) {
            String attrValue = (String)attrValues.next();
            ArrayList theObjectTypes = (ArrayList)this.objectClassToObjectTypeMap.get(attrValue.toLowerCase());
            if (theObjectTypes == null) continue;
            if (theObjectTypes.size() != 1) break;
            return (String)theObjectTypes.get(0);
        }
        return null;
    }

    private void insertObjectClassToObjectTypeEntry(String theObjectClass, String theObjectClassType) {
        String lcObjectClass = theObjectClass.toLowerCase();
        ArrayList<String> objectTypesForObjectClass = (ArrayList<String>)this.objectClassToObjectTypeMap.get(lcObjectClass);
        if (objectTypesForObjectClass == null) {
            objectTypesForObjectClass = new ArrayList<String>();
            this.objectClassToObjectTypeMap.put(lcObjectClass, objectTypesForObjectClass);
        }
        objectTypesForObjectClass.add(theObjectClassType);
    }

    private void populateMap(String[] theObjectClasses, String objectClassType) {
        if (theObjectClasses != null) {
            for (int i = 0; i < theObjectClasses.length; ++i) {
                this.insertObjectClassToObjectTypeEntry(theObjectClasses[i], objectClassType);
            }
        }
    }
}

