/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.admin;

import com.ibm.cognos.camaaa.internal.admin.handler.ProcessWellKnownQuery;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterFunctionCall;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchStep;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.ldap.admin.LdapQuery;
import com.ibm.cognos.camaaa.internal.ldap.admin.LdapQueryOptimizer;
import com.ibm.cognos.camaaa.internal.ldap.admin.MultipleQuery;
import com.ibm.cognos.camaaa.internal.ldap.admin.RelativeQuery;
import com.ibm.cognos.camaaa.internal.ldap.admin.SimpleQueryUsingDN;
import com.ibm.cognos.camaaa.internal.ldap.auth.LDAPVisa;
import com.ibm.cognos.camaaa.internal.ldap.common.NamespaceConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.naming.ldap.LdapContext;

public class QueryProcessor {
    private static final String MULTI_QUERY_ERROR = "Query with multiple steps are not supported";
    private final ArrayList queryOptimizers;
    private final NamespaceConfiguration namespaceConfiguration;

    public QueryProcessor(NamespaceConfiguration theNamespaceConfig) {
        this.namespaceConfiguration = theNamespaceConfig;
        this.queryOptimizers = new ArrayList();
        this.setupQueryOptimizer(theNamespaceConfig, "namespaceFolder");
        this.setupQueryOptimizer(theNamespaceConfig, "group");
        this.setupQueryOptimizer(theNamespaceConfig, "account");
        this.setupQueryOptimizer(theNamespaceConfig, "distributionList");
    }

    private boolean isAccountStep(SearchStep theStep) {
        return theStep.getAxis() == 3 && theStep.getNodeTest().equals("account") && theStep.getPredicate() == null;
    }

    private boolean isHomeStep(SearchStep theStep) {
        return theStep.getAxis() == 3 && theStep.getNodeTest().equals("home") && theStep.getPredicate() == null;
    }

    private boolean isNamespaceAccountQuery(SearchStep[] theSteps) {
        if (theSteps.length == 2) {
            return this.isHomeStep(theSteps[0]) && this.isAccountStep(theSteps[1]);
        }
        return false;
    }

    public void processQuery(LDAPVisa theVisa, LdapContext theLdapContext, Query theQuery, QueryResult theQueryResult, Set theAddtionalAttributes) throws LocalizableException {
        LdapQuery ldapQuery = this.simplifyQuery(theVisa, theLdapContext, theQuery, theQueryResult, theAddtionalAttributes);
        if (ldapQuery != null) {
            ldapQuery.run(theLdapContext, theQuery.getQueryOptions(), theQueryResult, theAddtionalAttributes);
        }
    }

    private void setupQueryOptimizer(NamespaceConfiguration theNamespaceConfig, String theObjectClass) {
        if (theNamespaceConfig.getObjectClassFilter(theObjectClass) != null) {
            this.queryOptimizers.add(new LdapQueryOptimizer(theNamespaceConfig, theObjectClass));
        }
    }

    private LdapQuery simplifyQuery(LDAPVisa theVisa, LdapContext theLdapContext, Query theQuery, QueryResult theQueryResult, Set theAddtionalAttributes) throws LocalizableException {
        SearchExpression searchExpression = theQuery.getSearchExpression();
        SearchStep[] steps = searchExpression.getSteps();
        LdapQuery ldapQuery = null;
        if (steps == null) {
            return null;
        }
        switch (steps.length) {
            case 1: {
                ldapQuery = this.simplifyStep(theVisa, theLdapContext, steps[0], theQueryResult, theQuery.getProperties());
                break;
            }
            case 2: {
                if (this.isNamespaceAccountQuery(steps)) {
                    String ldapFilter = this.namespaceConfiguration.getObjectClassFilter("account");
                    ldapQuery = new SimpleQueryUsingDN(theVisa.getUserDN(), this.namespaceConfiguration, "account", 0, ldapFilter, theQuery.getProperties());
                    break;
                }
                if (ProcessWellKnownQuery.isCamidFunctionCall((SearchStep)steps[0])) {
                    SearchPath searchPath = ProcessWellKnownQuery.getSearchPath((SearchFilterFunctionCall)((SearchFilterFunctionCall)steps[0].getPredicate()));
                    if (searchPath.getObjectID() == null) {
                        ldapQuery = this.simplifyStep(theVisa, theLdapContext, steps[1], theQueryResult, theQuery.getProperties());
                        break;
                    }
                    LdapQuery baseQuery = this.simplifyStep(theVisa, theLdapContext, steps[0], theQueryResult, null);
                    LdapQuery relativeQuery = this.simplifyStep(theVisa, theLdapContext, steps[1], theQueryResult, theQuery.getProperties());
                    ldapQuery = new RelativeQuery(baseQuery, relativeQuery);
                    break;
                }
                throw new RuntimeException(MULTI_QUERY_ERROR);
            }
            default: {
                throw new RuntimeException(MULTI_QUERY_ERROR);
            }
        }
        return ldapQuery;
    }

    private LdapQuery simplifyStep(LDAPVisa theVisa, LdapContext theLdapContext, SearchStep theSearchStep, QueryResult theQueryResult, String[] theProperties) throws LocalizableException {
        LdapQuery retval = null;
        Iterator it = this.queryOptimizers.iterator();
        ArrayList<LdapQuery> ldapQueries = new ArrayList<LdapQuery>();
        while (it.hasNext()) {
            LdapQueryOptimizer optimizer = (LdapQueryOptimizer)it.next();
            LdapQuery ldapQuery = optimizer.run(theVisa, theSearchStep, theProperties);
            if (ldapQuery == null) continue;
            ldapQueries.add(ldapQuery);
        }
        switch (ldapQueries.size()) {
            case 0: {
                retval = null;
                break;
            }
            case 1: {
                retval = (LdapQuery)ldapQueries.get(0);
                break;
            }
            default: {
                retval = new MultipleQuery(ldapQueries.toArray(new LdapQuery[0]));
            }
        }
        return retval;
    }
}

