/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.exception.AuthenticationException;
import com.ibm.cognos.camaaa.internal.auth.exception.InvalidCredentialsException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.ldap.auth.LDAPVisaFromCredentials;
import com.ibm.cognos.camaaa.internal.ldap.auth.handler.LDAPConnectionHandler;
import com.ibm.cognos.camaaa.internal.ldap.common.LdapUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

public class LogonToGenericLDAPWithCredentials
extends LDAPConnectionHandler {
    private static final String ACTOR = LogonToGenericLDAPWithCredentials.class.toString();
    private static final String[] ACCOUNT_LOOKUP_ATTRS = new String[]{"dn"};

    protected String[] getDefaultLookupAttributes() {
        return ACCOUNT_LOOKUP_ATTRS;
    }

    private List getMatchingDns(String theLookupString) throws InternalErrorException {
        ArrayList matchingDNs;
        try {
            matchingDNs = this.getUserDNs(theLookupString);
        }
        catch (NamingException e1) {
            throw new InternalErrorException(ACTOR, (Exception)e1);
        }
        catch (LocalizableException e) {
            throw new InternalErrorException(ACTOR, (Exception)((Object)e));
        }
        return matchingDNs;
    }

    protected ArrayList getUserDNs(String theLookupString) throws NamingException, LocalizableException {
        ArrayList matchingDN = new ArrayList();
        try (LdapContext context = this.getContext();){
            SearchControls ctls = new SearchControls();
            ctls.setCountLimit(this.getConfiguration().getSearchSizeLimit().intValue());
            ctls.setTimeLimit(this.getConfiguration().getSearchTimeLimit());
            ctls.setReturningAttributes(this.getDefaultLookupAttributes());
            ctls.setSearchScope(2);
            String name = null;
            String searchBaseDN = "";
            searchBaseDN = LdapUtil.getRelativeDN(context, this.getConfiguration().getBaseDN(), theLookupString);
            StringBuffer searchFilter = new StringBuffer();
            if (searchBaseDN == null) {
                name = "";
                searchFilter.append("(&");
                searchFilter.append(theLookupString);
                searchFilter.append(this.getConfiguration().getObjectClassFilter("account"));
                searchFilter.append(")");
            } else {
                name = searchBaseDN;
                searchFilter.append(this.getConfiguration().getObjectClassFilter("account"));
            }
            this.searchToGetUserDN(matchingDN, context, ctls, name, searchBaseDN, searchFilter);
            if (matchingDN.isEmpty()) {
                throw new InvalidCredentialsException(ACTOR);
            }
        }
        return matchingDN;
    }

    private void searchToGetUserDN(ArrayList matchingDN, LdapContext context, SearchControls ctls, String name, String searchBaseDN, StringBuffer searchFilter) throws NamingException {
        NamingEnumeration<SearchResult> answer = context.search(name, searchFilter.toString(), ctls);
        while (answer.hasMoreElements()) {
            SearchResult sr = answer.next();
            String entryDN = "";
            if (sr.isRelative()) {
                String parentDn = "";
                parentDn = searchBaseDN == null ? context.getNameInNamespace() : LdapUtil.getFullDN(context, context.getNameInNamespace(), searchBaseDN);
                entryDN = LdapUtil.getFullDN(context, parentDn, sr.getName());
            } else {
                String entryURL = sr.getName();
                context.addToEnvironment("java.naming.provider.url", entryURL);
                this.searchToGetUserDN(matchingDN, context, ctls, name, searchBaseDN, searchFilter);
            }
            matchingDN.add(entryDN);
        }
    }

    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        String lookupString = (String)theContext.get((Object)"userLookup");
        Map logonCredentials = (Map)theContext.get((Object)"logonCredentials");
        List matchingDNs = this.getMatchingDns(lookupString);
        String oldPassword = (String)logonCredentials.get("CAMOldPassword");
        String newPassword = (String)logonCredentials.get("CAMNewPassword");
        String password = null;
        password = oldPassword == null && newPassword == null ? (String)logonCredentials.get("password") : oldPassword;
        Iterator it = matchingDNs.iterator();
        LdapContext context = null;
        InvalidCredentialsException savedException = null;
        String bindDN = "";
        try {
            while (it.hasNext() && context == null) {
                bindDN = (String)it.next();
                try {
                    context = this.logonUser(bindDN, password);
                }
                catch (InvalidCredentialsException e) {
                    if (savedException != null) continue;
                    savedException = e;
                }
            }
        }
        catch (SoapFaultException sfe) {
            throw sfe;
        }
        catch (LocalizableException e) {
            throw new InternalErrorException(ACTOR, (Exception)((Object)e));
        }
        if (context == null) {
            throw savedException;
        }
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa", (Object)new LDAPVisaFromCredentials(context, bindDN));
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        super.init(theConfig);
    }

    @Override
    protected LdapContext processLogonFailure(NamingException e, String theNewPassword) throws AuthenticationException {
        throw new InvalidCredentialsException(ACTOR, (Exception)e);
    }
}

