/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.ldap.common;

import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import java.util.Enumeration;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapContext;

public final class LdapUtil {
    private static final String SEPARATOR = ",";
    private static final int BIN_0X_FF = 255;

    private LdapUtil() {
    }

    public static String getFullDN(LdapContext context, String dn1, String dn2) {
        String retval = "";
        try {
            Name nameToReturn = null;
            Name nameToPrepend = null;
            if (dn1 != null) {
                NameParser parser1 = context.getNameParser(dn1);
                nameToReturn = parser1.parse(dn1);
            }
            if (dn2 != null) {
                NameParser parser2 = context.getNameParser(dn2);
                nameToPrepend = parser2.parse(dn2);
            }
            if (nameToReturn != null) {
                nameToReturn = nameToReturn.addAll(nameToPrepend);
            }
            Enumeration<String> nameList = nameToReturn.getAll();
            while (nameList.hasMoreElements()) {
                String rdn = nameList.nextElement();
                if (retval.equals("")) {
                    retval = rdn;
                    continue;
                }
                retval = rdn + SEPARATOR + retval;
            }
        }
        catch (NamingException e) {
            return retval;
        }
        return retval;
    }

    public static String getParentDN(LdapContext context, String entryDN) {
        String parentDN = null;
        Name parent = null;
        try {
            NameParser nameParser = context.getNameParser(entryDN);
            Name entry = nameParser.parse(entryDN);
            if (entry.size() > 0) {
                parent = entry.getPrefix(entry.size() - 1);
            }
            if (parent != null) {
                Enumeration<String> nameList = parent.getAll();
                while (nameList.hasMoreElements()) {
                    String name = nameList.nextElement();
                    if (parentDN == null) {
                        parentDN = name;
                        continue;
                    }
                    parentDN = name + SEPARATOR + parentDN;
                }
            }
        }
        catch (NamingException e) {
            return null;
        }
        return parentDN;
    }

    public static String getRelativeDN(LdapContext context, String theParentDn, String theEntryDn) {
        String retval = null;
        Name rdn = null;
        try {
            NameParser parentParser = context.getNameParser(theParentDn);
            NameParser entryParser = context.getNameParser(theEntryDn);
            Name parent = parentParser.parse(theParentDn);
            Name entry = entryParser.parse(theEntryDn);
            if (entry.startsWith(parent)) {
                rdn = entry.getSuffix(parent.size());
            }
            if (rdn != null) {
                Enumeration<String> nameList = rdn.getAll();
                while (nameList.hasMoreElements()) {
                    String name = nameList.nextElement();
                    if (retval == null) {
                        retval = name;
                        continue;
                    }
                    retval = name + SEPARATOR + retval;
                }
            }
        }
        catch (NamingException e) {
            return null;
        }
        return retval;
    }

    public static String getUserLookup(Configuration configMgr) throws LocalizableException {
        String userExternalID = configMgr.getMandatoryValue("./*[local-name()='parameter'][@name=\"useExternalIdentity\"]/*[local-name()='value']/text()");
        boolean useExternalIdentity = Boolean.valueOf(userExternalID);
        String xpath = "./*[local-name()='parameter'][@name=\"userLookup\"]/*[local-name()='value']/text()";
        String userLookup = useExternalIdentity ? configMgr.getOptionalValue("./*[local-name()='parameter'][@name=\"userLookup\"]/*[local-name()='value']/text()", null) : configMgr.getMandatoryValue("./*[local-name()='parameter'][@name=\"userLookup\"]/*[local-name()='value']/text()");
        return userLookup;
    }

    private static String byte2hex(byte b) {
        String ret = Integer.toHexString(b & 0xFF);
        if (ret.length() < 2) {
            ret = "0" + ret;
        }
        return ret;
    }

    public static String searchableHexString(String hexObjectGUID) {
        String guidString = "";
        for (int i = 0; i < hexObjectGUID.length(); i += 2) {
            guidString = guidString + "\\";
            guidString = guidString + hexObjectGUID.substring(i, i + 2);
        }
        return guidString;
    }

    public static String getGuidCAMID(Attribute objectIDAttribute) {
        String objectGuidString = "";
        try {
            byte[] objectGUID = (byte[])objectIDAttribute.get();
            for (int i = 0; i < objectGUID.length; ++i) {
                objectGuidString = objectGuidString + LdapUtil.byte2hex(objectGUID[i]);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return objectGuidString;
    }
}

