/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.conformance;

import com.ibm.cognos.conformance.CNFMItemInfo;
import com.ibm.cognos.conformance.JDBCDriver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class CNFMCheckResult {
    private String m_sStatus = "";
    private CNFMItemInfo m_currentItemInfo;
    private ArrayList<CNFMItemInfo> m_candidateItemList;
    private static HashMap<String, String> m_messageList;
    protected static final String OUTPUT_INDENT = "     ";
    private static final String CCL_CFM_Label_Release = "CCL_CFM_Label_Release";
    private static final String CCL_CFM_Label_Update = "CCL_CFM_Label_Update";
    private static final String CCL_CFM_Label_Edition = "CCL_CFM_Label_Edition";
    private static final String CCL_CFM_Label_Name = "CCL_CFM_Label_Name";
    private static final String CCL_CFM_Label_PatchLevel = "CCL_CFM_Label_PatchLevel";
    private static final String CCL_CFM_Label_Vendor = "CCL_CFM_Label_Vendor";
    private static final String CCL_CFM_Label_Driver = "CCL_CFM_Label_Driver";
    private static final String CCL_CFM_Label_Supported = "CCL_CFM_Label_Supported";
    private static final String CCL_CFM_Label_Installed = "CCL_CFM_Label_Installed";
    private static final String CCL_CFM_Status_Supported = "CCL_CFM_Status_Supported";
    private static final String CCL_CFM_Status_NotSupported = "CCL_CFM_Status_NotSupported";
    private static final String CCL_CFM_Status_NotMatch = "CCL_CFM_Status_NotMatch";
    private static final String CCL_CFM_Message_NotMatch = "CCL_CFM_Message_NotMatch";
    private static final String CCL_CFM_Message_UnableCheck = "CCL_CFM_Message_UnableCheck";
    private static final String CCL_CFM_Message_Checking = "CCL_CFM_Message_Checking";
    private static final String CCL_CFM_Message_NotDetermined = "CCL_CFM_Message_NotDetermined";
    private static final String CCL_CFM_Message_NotSupported = "CCL_CFM_Message_NotSupported";

    public CNFMCheckResult() {
        this(new CNFMItemInfo(), new ArrayList<CNFMItemInfo>(), "");
    }

    public CNFMCheckResult(CNFMItemInfo itemInfo, ArrayList<CNFMItemInfo> itemlist) {
        this(itemInfo, itemlist, "");
    }

    public CNFMCheckResult(CNFMItemInfo itemInfo, ArrayList<CNFMItemInfo> itemlist, String status) {
        this.setStatus(status);
        this.setCurrentItemInfo(itemInfo);
        this.setCandidateItemList(itemlist);
    }

    public void setStatus(String status) {
        this.m_sStatus = status;
    }

    public String getStatus() {
        return this.m_sStatus;
    }

    public void setCurrentItemInfo(CNFMItemInfo curItemInfo) {
        this.m_currentItemInfo = curItemInfo;
    }

    public CNFMItemInfo getCurrentItemInfo() {
        return this.m_currentItemInfo;
    }

    public void setCandidateItemList(ArrayList<CNFMItemInfo> candidateItemList) {
        this.m_candidateItemList = candidateItemList;
    }

    public ArrayList<CNFMItemInfo> getCandidateItemList() {
        return this.m_candidateItemList;
    }

    public String buildOutput() {
        StringBuffer output = new StringBuffer();
        if (this.m_currentItemInfo != null && this.isCheckingStatusUnsupported()) {
            output.append(this.getMessageString(CCL_CFM_Message_NotSupported)).append("\n\n");
        } else {
            output.append(this.getMessageString(CCL_CFM_Message_NotDetermined)).append("\n\n");
        }
        if (this.m_currentItemInfo != null) {
            output.append(this.getMessageString(CCL_CFM_Label_Installed) + "\n" + this.buildVersionFromItem(this.m_currentItemInfo));
        }
        return output.toString();
    }

    private boolean isCheckingStatusUnknown() {
        return this.m_sStatus != null && (this.m_sStatus.equalsIgnoreCase("Unknown") || this.m_sStatus.equalsIgnoreCase("NotAvaliable"));
    }

    public boolean isCheckingOk() {
        return false;
    }

    private boolean isCheckingStatusUnsupported() {
        return this.m_sStatus != null && this.m_sStatus.equalsIgnoreCase("Not Supported");
    }

    private String buildVersionFromItems(ArrayList<CNFMItemInfo> candidateItemList) {
        if (candidateItemList != null) {
            StringBuffer verStr = new StringBuffer();
            for (int i = 0; i < candidateItemList.size(); ++i) {
                CNFMItemInfo item = candidateItemList.get(i);
                if (item.getStatus() != null && item.getStatus().equalsIgnoreCase("Not Supported")) continue;
                verStr.append(this.buildVersionFromItem(item)).append("\n");
            }
            return verStr.toString();
        }
        return "";
    }

    protected String buildVersionFromItem(CNFMItemInfo itemInfo) {
        if (itemInfo == null) {
            return "";
        }
        StringBuffer verStr = new StringBuffer();
        String str = itemInfo.getDescription();
        if (str != null && str.length() > 0) {
            verStr.append(OUTPUT_INDENT).append(this.getMessageString(CCL_CFM_Label_Name) + str);
            verStr.append("\n");
        } else {
            verStr.append(OUTPUT_INDENT).append(this.getMessageString(CCL_CFM_Label_Name) + itemInfo.getType());
            verStr.append("\n");
        }
        str = itemInfo.getVersionRelease();
        if (str != null && str.length() > 0) {
            verStr.append(OUTPUT_INDENT).append(this.getMessageString(CCL_CFM_Label_Release) + str);
            verStr.append("\n");
        }
        if ((str = itemInfo.getVersionUpdate()) != null && str.length() > 0) {
            verStr.append(OUTPUT_INDENT).append(this.getMessageString(CCL_CFM_Label_Update) + str);
            verStr.append("\n");
        }
        if ((str = itemInfo.getVersionPatchLevel()) != null && str.length() > 0) {
            verStr.append(OUTPUT_INDENT).append(this.getMessageString(CCL_CFM_Label_PatchLevel) + str);
            verStr.append("\n");
        }
        if ((str = itemInfo.getCurrentEdition()) != null && str.length() > 0) {
            verStr.append(OUTPUT_INDENT).append(this.getMessageString(CCL_CFM_Label_Edition) + str);
            verStr.append("\n");
        } else {
            ArrayList<String> list = itemInfo.getVersionEditions();
            if (list != null && list.size() > 0) {
                verStr.append(OUTPUT_INDENT).append(this.getMessageString(CCL_CFM_Label_Edition));
                for (int i = 0; i < list.size(); ++i) {
                    String editStr = list.get(i);
                    if (i > 0) {
                        verStr.append(",");
                    }
                    verStr.append(editStr);
                }
                verStr.append("\n");
            }
        }
        str = itemInfo.getVersionVendor();
        if (str != null && str.length() > 0) {
            verStr.append(OUTPUT_INDENT).append(this.getMessageString(CCL_CFM_Label_Vendor) + str);
            verStr.append("\n");
        }
        ArrayList<JDBCDriver> driverNameList = itemInfo.getJDBCDrivers();
        for (JDBCDriver driver : driverNameList) {
            String driverName = driver.getName();
            if (driverName == null || driverName.length() <= 0) continue;
            verStr.append(OUTPUT_INDENT).append(this.getMessageString(CCL_CFM_Label_Driver) + driverName).append(" - ");
            ArrayList<String> driverVerList = driver.getJDBCDriverVersions();
            if (driverVerList != null) {
                String separator = "";
                for (String ver : driverVerList) {
                    verStr.append(separator);
                    if (ver == null || ver.length() <= 0) continue;
                    verStr.append(ver);
                    separator = " ,";
                }
            }
            verStr.append("\n");
        }
        return verStr.toString();
    }

    protected String getStatusMessage() {
        String msg = this.getMessageString(this.m_sStatus);
        if (msg != null && msg.length() > 0) {
            return msg;
        }
        return this.getMessageString("NotAvaliable");
    }

    private static void initializeResources() {
        try {
            m_messageList = new HashMap();
            ResourceBundle textvals = ResourceBundle.getBundle("cclcfgapimsgs", Locale.getDefault());
            m_messageList.put(CCL_CFM_Label_Release, textvals.getString(CCL_CFM_Label_Release));
            m_messageList.put(CCL_CFM_Label_Update, textvals.getString(CCL_CFM_Label_Update));
            m_messageList.put(CCL_CFM_Label_Edition, textvals.getString(CCL_CFM_Label_Edition));
            m_messageList.put(CCL_CFM_Label_Name, textvals.getString(CCL_CFM_Label_Name));
            m_messageList.put(CCL_CFM_Label_PatchLevel, textvals.getString(CCL_CFM_Label_PatchLevel));
            m_messageList.put(CCL_CFM_Label_Vendor, textvals.getString(CCL_CFM_Label_Vendor));
            m_messageList.put(CCL_CFM_Label_Driver, textvals.getString(CCL_CFM_Label_Driver));
            m_messageList.put(CCL_CFM_Label_Supported, textvals.getString(CCL_CFM_Label_Supported));
            m_messageList.put(CCL_CFM_Label_Installed, textvals.getString(CCL_CFM_Label_Installed));
            m_messageList.put(CCL_CFM_Status_Supported, textvals.getString(CCL_CFM_Status_Supported));
            m_messageList.put(CCL_CFM_Status_NotSupported, textvals.getString(CCL_CFM_Status_NotSupported));
            m_messageList.put(CCL_CFM_Status_NotMatch, textvals.getString(CCL_CFM_Status_NotMatch));
            m_messageList.put(CCL_CFM_Message_NotMatch, textvals.getString(CCL_CFM_Message_NotMatch));
            m_messageList.put(CCL_CFM_Message_UnableCheck, textvals.getString(CCL_CFM_Message_UnableCheck));
            m_messageList.put(CCL_CFM_Message_Checking, textvals.getString(CCL_CFM_Message_Checking));
            m_messageList.put(CCL_CFM_Message_NotDetermined, textvals.getString(CCL_CFM_Message_NotDetermined));
            m_messageList.put(CCL_CFM_Message_NotSupported, textvals.getString(CCL_CFM_Message_NotSupported));
            m_messageList.put("NotAvaliable", textvals.getString(CCL_CFM_Status_NotMatch));
            m_messageList.put("Unknown", textvals.getString(CCL_CFM_Status_NotMatch));
            m_messageList.put("Not Supported", textvals.getString(CCL_CFM_Status_NotSupported));
            m_messageList.put("Active", textvals.getString(CCL_CFM_Status_Supported));
            m_messageList.put("Compatible", textvals.getString(CCL_CFM_Status_Supported));
        }
        catch (Exception e) {
            m_messageList = null;
        }
    }

    private String getMessageString(String msgId) {
        if (m_messageList != null) {
            return m_messageList.get(msgId) + " ";
        }
        return "";
    }

    static {
        CNFMCheckResult.initializeResources();
    }
}

