/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.conformance;

import com.ibm.cognos.conformance.CNFMCategoryInfo;
import com.ibm.cognos.conformance.CNFMConstants;
import com.ibm.cognos.conformance.CNFMItemInfo;
import com.ibm.cognos.conformance.CNFMProductInfo;
import com.ibm.cognos.conformance.JDBCDriver;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CNFMParser
extends CNFMConstants {
    private static ArrayList<CNFMProductInfo> m_lCogProducts = new ArrayList();
    static boolean m_bInitialized = false;

    protected static boolean parse() {
        ArrayList<CNFMProductInfo> prodList = new ArrayList<CNFMProductInfo>();
        m_lCogProducts = prodList;
        try {
            Document cnfmDoc = CNFMParser.loadConformanceDoc();
            if (cnfmDoc == null) {
                return false;
            }
            Element rootElem = cnfmDoc.getRootElement();
            List lProductElems = rootElem.elements("product");
            if (lProductElems.size() == 0) {
                return false;
            }
            for (int j = 0; j < lProductElems.size(); ++j) {
                Element prodElem = (Element)lProductElems.get(j);
                if (prodElem == null) continue;
                CNFMProductInfo prodInfo = CNFMParser.parseProductInfo(prodElem);
                prodList.add(prodInfo);
            }
        }
        catch (Exception e) {
            m_lCogProducts = new ArrayList();
            return false;
        }
        return true;
    }

    private static CNFMProductInfo parseProductInfo(Element prodElem) {
        CNFMProductInfo result = new CNFMProductInfo();
        ArrayList<CNFMCategoryInfo> catList = new ArrayList<CNFMCategoryInfo>();
        String prodName = prodElem.attributeValue("name");
        String prodVer = prodElem.attributeValue("version");
        if (prodName == null) {
            prodName = "";
        }
        if (prodVer == null) {
            prodVer = "";
        }
        result.setProductName(prodName);
        result.setProductVersion(prodVer);
        List lCatElems = prodElem.elements("category");
        for (int j = 0; j < lCatElems.size(); ++j) {
            Element catElem = (Element)lCatElems.get(j);
            if (catElem == null) continue;
            CNFMCategoryInfo catInfo = CNFMParser.parseCategoryInfo(catElem, prodName, prodVer);
            catList.add(catInfo);
        }
        result.setCategories(catList);
        return result;
    }

    private static CNFMCategoryInfo parseCategoryInfo(Element catElem, String prodName, String prodVer) {
        CNFMCategoryInfo result = new CNFMCategoryInfo();
        ArrayList<CNFMItemInfo> itemList = new ArrayList<CNFMItemInfo>();
        String catName = catElem.attributeValue("name");
        if (catName == null) {
            catName = "";
        }
        result.setCategoryName(catName);
        result.setProductName(prodName);
        result.setProductVersion(prodVer);
        List itemElems = catElem.elements("item");
        for (int j = 0; j < itemElems.size(); ++j) {
            Element itemElem = (Element)itemElems.get(j);
            if (itemElem == null) continue;
            CNFMItemInfo itemInfo = CNFMParser.parseItemInfo(itemElem);
            itemInfo.setCategoryName(catName);
            itemInfo.setProductName(prodName);
            itemInfo.setProductVersion(prodVer);
            itemList.add(itemInfo);
        }
        result.setItems(itemList);
        return result;
    }

    private static CNFMItemInfo parseItemInfo(Element itemElem) {
        Element platElem;
        CNFMItemInfo result = new CNFMItemInfo();
        String itemType = itemElem.attributeValue("type");
        result.setType(itemType != null ? itemType : "");
        String itemOSType = itemElem.attributeValue("architecture");
        result.setArchitecture(itemOSType != null ? itemOSType : "");
        String itemFloor = itemElem.attributeValue("floor", "false");
        result.setFloorValue(itemFloor.equalsIgnoreCase("true"));
        String itemCeiling = itemElem.attributeValue("ceiling", "false");
        result.setCeilingValue(itemCeiling.equalsIgnoreCase("true"));
        result.setDescription(CNFMParser.getElementValue(itemElem, "description"));
        result.setStatus(CNFMParser.getElementValue(itemElem, "status"));
        Element verElem = itemElem.element("version");
        if (verElem != null) {
            result.setVersionPatchLevel(CNFMParser.getElementValue(verElem, "patchLevel"));
            result.setVersionRelease(CNFMParser.getElementValue(verElem, "release"));
            result.setVersionUpdate(CNFMParser.getElementValue(verElem, "update"));
            result.setVersionVendor(CNFMParser.getElementValue(verElem, "vendor"));
            result.setVersionArchitecture(CNFMParser.getElementValue(verElem, "architecture"));
            Element editionsElem = verElem.element("editions");
            if (editionsElem != null) {
                result.setVersionEditions(CNFMParser.getElementValueList(editionsElem, "edition"));
            }
        }
        if ((platElem = itemElem.element("platform")) != null) {
            result.setPlatformArchs(CNFMParser.getElementValueList(platElem, "arch"));
        }
        List driverElements = itemElem.elements("driver");
        for (Element driverElem : driverElements) {
            if (driverElem == null) continue;
            JDBCDriver driver = new JDBCDriver();
            driver.setName(driverElem.attributeValue("name"));
            driver.setJDBCDriverVersions(CNFMParser.getElementValueList(driverElem, "version"));
            result.addJDBCDriver(driver);
        }
        return result;
    }

    private static ArrayList<String> getElementValueList(Element parentElem, String elemName) {
        ArrayList<String> valueList = new ArrayList<String>();
        List elems = parentElem.elements(elemName);
        for (int i = 0; i < elems.size(); ++i) {
            Element elem = (Element)elems.get(i);
            if (elem == null) continue;
            String value = elem.getText();
            valueList.add(value != null ? value : "");
        }
        return valueList;
    }

    private static String getElementValue(Element parentElem, String elemName) {
        String elemValue;
        Element elem = parentElem.element(elemName);
        if (elem != null && (elemValue = elem.getText()) != null) {
            return elemValue;
        }
        return "";
    }

    private static Document loadConformanceDoc() {
        SAXReader saxReader = new SAXReader();
        Document cnfmDoc = null;
        try {
            InputStream cnfmIs = CNFMParser.class.getResourceAsStream("/conformance/conformance.xml");
            cnfmDoc = cnfmIs == null ? null : saxReader.read(cnfmIs);
        }
        catch (DocumentException e) {
            cnfmDoc = null;
        }
        return cnfmDoc;
    }

    public static ArrayList<CNFMProductInfo> getConformanceList() {
        if (!m_bInitialized) {
            m_bInitialized = CNFMParser.parse();
        }
        return m_lCogProducts;
    }
}

