/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ReflectionSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.httpclient.ssl.AllowAllHostnameVerifier;
import org.apache.commons.httpclient.ssl.BrowserCompatHostnameVerifier;
import org.apache.commons.httpclient.ssl.StrictHostnameVerifier;
import org.apache.commons.httpclient.ssl.TrustManagerDecorator;
import org.apache.commons.httpclient.ssl.TrustStrategy;
import org.apache.commons.httpclient.ssl.X509HostnameVerifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";
    public static final String SSLV2 = "SSLv2";
    private final SSLSocketFactory socketfactory;
    private final X509HostnameVerifier hostnameVerifier;
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = new StrictHostnameVerifier();
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$protocol$SSLProtocolSocketFactory == null ? (class$org$apache$commons$httpclient$protocol$SSLProtocolSocketFactory = SSLProtocolSocketFactory.class$("org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory")) : class$org$apache$commons$httpclient$protocol$SSLProtocolSocketFactory));
    private static final SSLProtocolSocketFactory factory = new SSLProtocolSocketFactory();
    static /* synthetic */ Class class$org$apache$commons$httpclient$protocol$SSLProtocolSocketFactory;

    static SSLProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    public SSLProtocolSocketFactory() {
        this(SSLProtocolSocketFactory.createDefaultSSLContext());
    }

    public SSLProtocolSocketFactory(SSLContext sslContext) {
        this(sslContext, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLProtocolSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        this.socketfactory = sslContext.getSocketFactory();
        this.hostnameVerifier = hostnameVerifier;
    }

    private static SSLContext createSSLContext(String algorithm, KeyStore keystore, String keystorePassword, KeyStore truststore, SecureRandom random, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        if (algorithm == null) {
            algorithm = TLS;
        }
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, keystorePassword != null ? keystorePassword.toCharArray() : null);
        KeyManager[] keymanagers = kmfactory.getKeyManagers();
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(truststore);
        TrustManager[] trustmanagers = tmfactory.getTrustManagers();
        if (trustmanagers != null && trustStrategy != null) {
            for (int i = 0; i < trustmanagers.length; ++i) {
                TrustManager tm = trustmanagers[i];
                if (!(tm instanceof X509TrustManager)) continue;
                trustmanagers[i] = new TrustManagerDecorator((X509TrustManager)tm, trustStrategy);
            }
        }
        SSLContext sslcontext = SSLContext.getInstance(algorithm);
        sslcontext.init(keymanagers, trustmanagers, random);
        return sslcontext;
    }

    private static SSLContext createDefaultSSLContext() {
        try {
            return SSLProtocolSocketFactory.createSSLContext(TLS, null, null, null, null, null);
        }
        catch (Exception ex) {
            LOG.error((Object)("Failure initializing default SSL context\n" + ex.toString()));
            return null;
        }
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return SSLSocketFactory.getDefault().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        Socket sock = null;
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            sock = this.createSocket(host, port, localAddress, localPort);
        } else {
            sock = ReflectionSocketFactory.createSocket("javax.net.ssl.SSLSocketFactory", host, port, localAddress, localPort, timeout);
            if (sock == null) {
                sock = ControllerThreadSocketFactory.createSocket(this, host, port, localAddress, localPort, timeout);
            }
        }
        String hostname = host;
        String s = ":" + port;
        if (hostname.endsWith(s)) {
            hostname = hostname.substring(0, hostname.length() - s.length());
        }
        SSLSocket sslsock = sock instanceof SSLSocket ? (SSLSocket)sock : (SSLSocket)this.socketfactory.createSocket(sock, hostname, port, true);
        if (this.hostnameVerifier != null) {
            try {
                this.hostnameVerifier.verify(hostname, sslsock);
            }
            catch (IOException iox) {
                try {
                    sslsock.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
                throw iox;
            }
        }
        return sslsock;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return SSLSocketFactory.getDefault().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.createLayeredSocket(socket, host, port, autoClose);
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.socketfactory.createSocket(socket, host, port, autoClose);
        if (this.hostnameVerifier != null) {
            this.hostnameVerifier.verify(host, sslSocket);
        }
        return sslSocket;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

