/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.launcher;

import com.ibm.ba.flint.client.BorrowedFlintClient;
import com.ibm.ba.flint.client.FlintClientBuilder;
import com.ibm.ba.flint.client.FlintClientFactory;
import com.ibm.ba.flint.client.FlintClientPool;
import com.ibm.ba.flint.client.Services;
import com.ibm.ba.flint.launcher.HealthMonitor;
import com.ibm.ba.flint.launcher.Launcher;
import com.ibm.ba.flint.launcher.LauncherListener;
import com.ibm.ba.flint.launcher.ProcessMonitor;
import com.ibm.ba.flint.launcher.SslParams;
import com.ibm.ba.flint.launcher.logging.JsonEventProcessor;
import com.ibm.ba.flint.launcher.logging.JsonEventReader;
import com.ibm.ba.flint.launcher.logging.SLF4JLogEventHandler;
import com.ibm.ba.flint.thrift.core.CoreService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaProcessLauncher
implements Launcher {
    public static final int EPHERMERAL_PORT = 0;
    private static final String IBM_VERBOSE_GC_JAVA_OPTION = "-verbose:gc";
    private static final String IBM_VERBOSE_GC_LOG_JAVA_OPTION = "-Xverbosegclog";
    private static final String ORACLE_VERBOSE_GC_LOG_JAVA_OPTION = "-Xloggc";
    private static final String FLINT_SERVER_APP_MAIN_CLASS = "com.ibm.ba.flint.server.FlintServerApp";
    private static final String APP_CONF_STDIN_HEADER = "==BEGIN-FLINT-CONF==";
    private static final String APP_CONF_STDIN_FOOTER = "==END-FLINT-CONF==";
    private static final String MSG_SERVER_NOT_STARTED = "The server has not yet been started";
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaProcessLauncher.class);
    private final String bindHost;
    private final String portFile;
    private final SslParams clientSslParams;
    private final List<String> commandArgs;
    private final Map<String, String> appConfStdIn;
    private final Map<String, String> envVariables;
    private final ProcessMonitor.InputConsumer inputConsumer;
    private final ConcurrentLinkedQueue<LauncherListener> listeners = new ConcurrentLinkedQueue();
    private final FlintClientFactory clientFactory;
    private final FlintClientPool clientPool;
    private final CountDownLatch terminatedLatch = new CountDownLatch(1);
    private volatile Process process;
    private int bindPort;
    private volatile ProcessMonitor procMonitor;
    private volatile HealthMonitor healthMonitor;
    private volatile boolean serving = false;

    private JavaProcessLauncher(String theBindHost, int theBindPort, String thePortFile, SslParams theClientSslParams, List<String> theCommandArgs, Map<String, String> theAppConfStdIn, Map<String, String> theEnvVariables, boolean isLoggingOverStdOut) {
        this.bindHost = theBindHost;
        this.bindPort = theBindPort;
        this.portFile = thePortFile;
        this.clientSslParams = theClientSslParams;
        this.commandArgs = theCommandArgs;
        this.appConfStdIn = theAppConfStdIn;
        this.envVariables = theEnvVariables;
        this.inputConsumer = isLoggingOverStdOut ? this::consumeProccessInputAsLogEvents : this::consumeProcessInputAsConsoleOut;
        this.clientFactory = this.createClientFactory();
        this.clientPool = new FlintClientPool(this.clientFactory, 1, 30);
    }

    private FlintClientFactory createClientFactory() {
        FlintClientBuilder builder = new FlintClientBuilder().setConnectTimeout(5000).setHost(this.bindHost);
        if (0 == this.bindPort) {
            builder.setPortProvider(this::resolveBindPortFromFile);
        } else {
            builder.setPort(this.bindPort);
        }
        if (null != this.clientSslParams) {
            builder.setSSLEnabled(true);
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.clientSslParams.getProtocol()})) {
                builder.setSSLProtocol(this.clientSslParams.getProtocol());
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.clientSslParams.getKeyStorePath()})) {
                builder.setSSLKeyStore(this.clientSslParams.getKeyStorePath(), this.clientSslParams.getKeyStorePassword(), this.clientSslParams.getKeyManagerType(), this.clientSslParams.getKeyStoreType());
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.clientSslParams.getTrustStorePath()})) {
                builder.setSSLTrustStore(this.clientSslParams.getTrustStorePath(), this.clientSslParams.getTrustStorePassword(), this.clientSslParams.getTrustManagerType(), this.clientSslParams.getTrustStoreType());
            }
        }
        return builder.asFactory();
    }

    @Override
    public String getBindHost() {
        return this.bindHost;
    }

    @Override
    public int getBindPort() {
        return this.resolveBindPortFromFile();
    }

    String getPortFile() {
        return this.portFile;
    }

    private int resolveBindPortFromFile() {
        if (0 == this.bindPort) {
            File file = new File(this.portFile);
            if (file.exists()) {
                try {
                    String portStr = FileUtils.readFileToString((File)file);
                    this.bindPort = Integer.parseInt(portStr);
                    LOGGER.info("Resolved ephemeral bind port ({})", (Object)this.bindPort);
                }
                catch (IOException | NumberFormatException ex) {
                    LOGGER.error("Failed to read port file: {}", (Object)this.portFile, (Object)ex);
                }
            } else {
                LOGGER.warn("Port file not found: {}", (Object)this.portFile);
            }
        }
        return this.bindPort;
    }

    @Override
    public SslParams getClientSslParams() {
        return this.clientSslParams;
    }

    Map<String, String> getAppConfStdIn() {
        return Collections.unmodifiableMap(this.appConfStdIn);
    }

    Map<String, String> getEnvVariables() {
        return Collections.unmodifiableMap(this.envVariables);
    }

    @Override
    public FlintClientFactory getClientFactory() {
        return this.clientFactory;
    }

    @Override
    public FlintClientPool getClientPool() {
        return this.clientPool;
    }

    @Override
    public void addListener(LauncherListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(LauncherListener listener) {
        return this.listeners.remove(listener);
    }

    public List<String> getCommandArgs() {
        return Collections.unmodifiableList(this.commandArgs);
    }

    @Override
    public boolean hasStarted() {
        return null != this.process;
    }

    @Override
    public boolean isRunning() {
        return null != this.process && this.process.isAlive();
    }

    @Override
    public boolean isServing() {
        return this.serving;
    }

    @Override
    public boolean hasTerminated() {
        return null != this.process && !this.process.isAlive() && this.terminatedLatch.getCount() == 0L;
    }

    @Override
    public void launch() throws IOException {
        if (this.hasStarted()) {
            throw new IllegalStateException("Server has already been started");
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.portFile})) {
            FileUtils.deleteQuietly((File)new File(this.portFile));
        }
        this.process = this.startProcess();
        this.procMonitor = new ProcessMonitor(this.process).setInputConsumer(this.inputConsumer).setTerminationListener(this::handleProcessTermination);
        this.healthMonitor = new HealthMonitor(this.clientPool, 2000).setHealthListener(this::handleHealthStatusChanged);
        this.fireOnServerStarted();
        this.procMonitor.start();
        this.healthMonitor.start();
        if (!this.appConfStdIn.isEmpty()) {
            this.sendAppConfToStdIn();
        }
    }

    @Override
    public boolean shutdown(boolean forcibly) {
        this.expectServerStarted();
        this.healthMonitor.close();
        if (forcibly) {
            return this.shutdownForcibly();
        }
        return this.shutdownGracefully();
    }

    @Override
    public boolean quiesceAndShutdown(long timeoutSeconds) {
        this.expectServerStarted();
        if (this.quiesce(timeoutSeconds)) {
            LOGGER.info("Server quiesced successfully; proceeding with shutdown.");
        } else {
            LOGGER.warn("An attempt to quiesce server has failed to complete in the elapsed time; proceeding with shutdown, anyway.");
        }
        return this.shutdownGracefully();
    }

    @Override
    public boolean waitForServing(long timeoutMs) throws InterruptedException {
        this.expectServerStarted();
        Duration timeoutDur = Duration.ofMillis(timeoutMs);
        Instant startTime = Instant.now();
        while (!this.isServing()) {
            if (this.hasTerminated()) {
                return false;
            }
            Duration elapsedDur = Duration.between(startTime, Instant.now());
            Duration remainingDur = timeoutDur.minus(elapsedDur);
            if (remainingDur.isNegative()) {
                return false;
            }
            Thread.sleep(Math.min(200L, remainingDur.toMillis()));
        }
        return true;
    }

    @Override
    public boolean waitForTerminate(long timeoutMs) throws InterruptedException {
        this.expectServerStarted();
        Duration timeoutDur = Duration.ofMillis(timeoutMs);
        Instant startTime = Instant.now();
        while (!this.hasTerminated()) {
            Duration elapsedDur = Duration.between(startTime, Instant.now());
            Duration remainingDur = timeoutDur.minus(elapsedDur);
            if (remainingDur.isNegative()) {
                return false;
            }
            if (!this.terminatedLatch.await(remainingDur.toMillis(), TimeUnit.MILLISECONDS)) continue;
            break;
        }
        return true;
    }

    @Override
    public int exitValue() {
        this.expectServerStarted();
        if (!this.hasTerminated()) {
            throw new IllegalStateException("Server has not yet terminated");
        }
        return this.process.exitValue();
    }

    private void expectServerStarted() {
        if (!this.hasStarted()) {
            throw new IllegalStateException(MSG_SERVER_NOT_STARTED);
        }
    }

    private Process startProcess() throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(this.commandArgs).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectErrorStream(true);
        Map<String, String> existingEnvVariables = pb.environment();
        existingEnvVariables.putAll(this.envVariables);
        return pb.start();
    }

    private boolean shutdownForcibly() {
        LOGGER.warn("Attempting forceful shutdown of server");
        this.process.destroy();
        try {
            if (this.waitForTerminate(5000L)) {
                return true;
            }
        }
        catch (InterruptedException ex) {
            return false;
        }
        this.process.destroyForcibly();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean quiesce(long timeoutSeconds) {
        LOGGER.warn("Attempting quiesce of server [timeoutSeconds:{}]", (Object)timeoutSeconds);
        try (BorrowedFlintClient borrowed = new BorrowedFlintClient(this.clientPool);){
            boolean bl = ((CoreService.Iface)borrowed.client().getService(Services.CORE_SERVICE)).quiesce(timeoutSeconds);
            return bl;
        }
        catch (TException ex) {
            LOGGER.error("Failed to quiesce active requests on server", (Throwable)ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shutdownGracefully() {
        LOGGER.warn("Attempting graceful shutdown of server");
        try (BorrowedFlintClient borrowed = new BorrowedFlintClient(this.clientPool);){
            ((CoreService.Iface)borrowed.client().getService(Services.CORE_SERVICE)).shutdown();
            boolean bl = true;
            return bl;
        }
        catch (TException ex) {
            LOGGER.error("Failed to shutdown gracefully", (Throwable)ex);
            return false;
        }
    }

    private void sendAppConfToStdIn() {
        PrintWriter writer = new PrintWriter(this.process.getOutputStream());
        writer.println(APP_CONF_STDIN_HEADER);
        for (Map.Entry<String, String> prop : this.appConfStdIn.entrySet()) {
            writer.append(prop.getKey()).append('=').append(prop.getValue());
            writer.println();
        }
        writer.println(APP_CONF_STDIN_FOOTER);
        writer.flush();
    }

    private void consumeProcessInputAsConsoleOut(InputStream in) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while (null != (line = reader.readLine())) {
                this.fireOnServerConsoleOut(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void consumeProccessInputAsLogEvents(InputStream in) {
        JsonEventReader reader = new JsonEventReader(in);
        SLF4JLogEventHandler handler = new SLF4JLogEventHandler();
        try (JsonEventProcessor processor = new JsonEventProcessor(reader, handler);){
            processor.process();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handleProcessTermination(int exitCode) {
        if (null != this.healthMonitor) {
            this.healthMonitor.close();
        }
        this.fireOnServerTerminated(exitCode);
        this.terminatedLatch.countDown();
    }

    private void handleHealthStatusChanged(boolean up) {
        if (up) {
            this.serving = true;
            this.fireOnServerConnectionUp();
        } else {
            this.serving = false;
            this.fireOnServerConnectionDown();
        }
    }

    private void fireOnServerStarted() {
        for (LauncherListener listener : this.listeners) {
            listener.onServerStarted(this);
        }
    }

    private void fireOnServerConnectionUp() {
        for (LauncherListener listener : this.listeners) {
            listener.onServerConnectionUp(this);
        }
    }

    private void fireOnServerConnectionDown() {
        for (LauncherListener listener : this.listeners) {
            listener.onServerConnectionDown(this);
        }
    }

    private void fireOnServerTerminated(int exitValue) {
        for (LauncherListener listener : this.listeners) {
            listener.onServerTerminated(this, exitValue);
        }
    }

    private void fireOnServerConsoleOut(String line) {
        for (LauncherListener listener : this.listeners) {
            listener.onServerConsoleOut(this, line);
        }
    }

    public static class Builder {
        private final String jarPath;
        private final List<String> extraClasspath = new ArrayList<String>();
        private final Map<String, String> extraSysProps = new HashMap<String, String>();
        private final List<String> extraJavaOptions = new ArrayList<String>();
        private final List<String> javaAgents = new ArrayList<String>();
        private final List<String> appConfFiles = new ArrayList<String>();
        private final Map<String, String> appConfStdIn = new HashMap<String, String>();
        private String javaHome;
        private int minHeapMB = -1;
        private int maxHeapMB = -1;
        private int maxDirectMB = 256;
        private final Map<String, String> environmentVariables = new HashMap<String, String>();
        private String bindHost = "localhost";
        private int bindPort = 58008;
        private int clientTimeout = -1;
        private int numSparkThreads = -1;
        private int minWorkers = -1;
        private int maxWorkers = -1;
        private boolean disableSparkUI = false;
        private boolean keepAliveByStdIn = false;
        private boolean quiet = false;
        private String portFile;
        private boolean loggingOverStdOut = false;
        private String scratchDir;
        private String buffersDir;
        private String warehouseDir;
        private String resultCacheDir;
        private String metricsNS;
        private String metricsConfFile;
        private String log4jConfFile;
        private SslParams clientSslParams;

        public Builder(String theJarPath) {
            if (StringUtils.isEmpty((CharSequence)theJarPath)) {
                throw new IllegalArgumentException("theJarPath must be non-empty");
            }
            this.jarPath = theJarPath;
        }

        private static String classPathSep() {
            if (SystemUtils.IS_OS_WINDOWS) {
                return ";";
            }
            return ":";
        }

        public Builder setJavaHome(String theJavaHome) {
            if (StringUtils.isEmpty((CharSequence)theJavaHome)) {
                throw new IllegalArgumentException("theJavaHome must be non-empty");
            }
            this.javaHome = theJavaHome;
            return this;
        }

        public Builder setMinHeapMB(int sizeMB) {
            if (sizeMB < 1) {
                throw new IllegalArgumentException("sizeMB must be > 0");
            }
            this.minHeapMB = sizeMB;
            return this;
        }

        public Builder setMaxHeapMB(int sizeMB) {
            if (sizeMB < 1) {
                throw new IllegalArgumentException("sizeMB must be > 0");
            }
            this.maxHeapMB = sizeMB;
            return this;
        }

        public Builder setMaxDirectMB(int sizeMB) {
            if (sizeMB < 1) {
                throw new IllegalArgumentException("sizeMB must be > 0");
            }
            this.maxDirectMB = sizeMB;
            return this;
        }

        public Builder setVerboseGC(boolean isVendorIBM, String verboseGCLogPath) {
            if (null == verboseGCLogPath || verboseGCLogPath.isEmpty()) {
                throw new IllegalArgumentException("verboseGCLogPath must be non-empty");
            }
            List staleVerboseGCLogOpts = this.extraJavaOptions.stream().filter(opt -> opt.contains(JavaProcessLauncher.IBM_VERBOSE_GC_LOG_JAVA_OPTION) || opt.contains(JavaProcessLauncher.ORACLE_VERBOSE_GC_LOG_JAVA_OPTION)).collect(Collectors.toList());
            staleVerboseGCLogOpts.add(JavaProcessLauncher.IBM_VERBOSE_GC_JAVA_OPTION);
            this.extraJavaOptions.removeAll(staleVerboseGCLogOpts);
            if (isVendorIBM) {
                this.extraJavaOptions.add(JavaProcessLauncher.IBM_VERBOSE_GC_JAVA_OPTION);
                this.extraJavaOptions.add("-Xverbosegclog:" + verboseGCLogPath);
            } else {
                this.extraJavaOptions.add("-Xloggc:" + verboseGCLogPath);
            }
            return this;
        }

        public Builder setUserTimezone(String timezone) {
            if (null != timezone) {
                this.addExtraSysProp("user.timezone", timezone);
            }
            return this;
        }

        public Builder addExtraClasspath(List<String> classPaths) {
            if (null == classPaths) {
                throw new IllegalArgumentException("classPaths must be non-null");
            }
            for (String path : classPaths) {
                this.addExtraClasspath(path);
            }
            return this;
        }

        public Builder addExtraClasspath(String classPath) {
            if (StringUtils.isEmpty((CharSequence)classPath)) {
                throw new IllegalArgumentException("classPath must be non-empty");
            }
            this.extraClasspath.add(classPath);
            return this;
        }

        public Builder addExtraSysProp(String key, String value) {
            if (StringUtils.isEmpty((CharSequence)key)) {
                throw new IllegalArgumentException("key must be non-empty");
            }
            if (null == value) {
                throw new IllegalArgumentException("value must be non-null");
            }
            this.extraSysProps.put(key, value);
            return this;
        }

        public Builder addExtraJavaOpts(String extraJavaOpts) {
            if (StringUtils.isEmpty((CharSequence)extraJavaOpts) || StringUtils.isEmpty((CharSequence)extraJavaOpts.trim())) {
                throw new IllegalArgumentException("extraJavaOpts must be non-empty");
            }
            String[] options = extraJavaOpts.trim().split("\\s+");
            this.extraJavaOptions.addAll(Arrays.asList(options));
            return this;
        }

        public Builder addJavaAgent(String agent) {
            if (StringUtils.isEmpty((CharSequence)agent)) {
                throw new IllegalArgumentException("agent must be non-empty");
            }
            this.javaAgents.add(agent);
            return this;
        }

        public Builder addAppConfFile(String path) {
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw new IllegalArgumentException("app conf file must be non-empty");
            }
            this.appConfFiles.add(path);
            return this;
        }

        public Builder addAppConfStdIn(String key, String value) {
            if (StringUtils.isEmpty((CharSequence)key)) {
                throw new IllegalArgumentException("key must be non-empty");
            }
            if (null == value) {
                throw new IllegalArgumentException("value must be non-null");
            }
            this.appConfStdIn.put(key, value);
            return this;
        }

        Builder addAppConfStdInIfNotEmpty(String key, String value) {
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                return this.addAppConfStdIn(key, value);
            }
            return this;
        }

        public Builder setEfsKeyPair(String algorithm, String pubKey, String privKey) {
            if (StringUtils.isEmpty((CharSequence)algorithm)) {
                throw new IllegalArgumentException("algorithm must be non-empty");
            }
            if (StringUtils.isEmpty((CharSequence)pubKey)) {
                throw new IllegalArgumentException("pubKey must be non-empty");
            }
            if (StringUtils.isEmpty((CharSequence)privKey)) {
                throw new IllegalArgumentException("privKey must be non-empty");
            }
            this.addAppConfStdIn("spark.hadoop.fs.efs.key.algorithm", algorithm);
            this.addAppConfStdIn("spark.hadoop.fs.efs.key.public", pubKey);
            this.addAppConfStdIn("spark.hadoop.fs.efs.key.private", privKey);
            return this;
        }

        public Builder setServerSslParams(SslParams sslParams) {
            if (null != sslParams) {
                this.addAppConfStdIn("flint.ssl.enabled", Boolean.toString(true));
                this.addAppConfStdIn("flint.ssl.requiresClientAuth", Boolean.toString(sslParams.isRequiresClientAuth()));
                this.addAppConfStdInIfNotEmpty("flint.ssl.protocol", sslParams.getProtocol());
                this.addAppConfStdInIfNotEmpty("flint.ssl.allowedCiphers", sslParams.getAllowedCiphers());
                if (StringUtils.isNotEmpty((CharSequence)sslParams.getKeyStorePath())) {
                    this.addAppConfStdIn("flint.ssl.keyStore", sslParams.getKeyStorePath());
                    this.addAppConfStdIn("flint.ssl.keyStorePassword", sslParams.getKeyStorePassword());
                    this.addAppConfStdInIfNotEmpty("flint.ssl.keyManagerType", sslParams.getKeyManagerType());
                    this.addAppConfStdInIfNotEmpty("flint.ssl.keyStoreType", sslParams.getKeyStoreType());
                }
                if (StringUtils.isNotEmpty((CharSequence)sslParams.getTrustStorePath())) {
                    this.addAppConfStdIn("flint.ssl.trustStore", sslParams.getTrustStorePath());
                    this.addAppConfStdIn("flint.ssl.trustStorePassword", sslParams.getTrustStorePassword());
                    this.addAppConfStdInIfNotEmpty("flint.ssl.trustManagerType", sslParams.getTrustManagerType());
                    this.addAppConfStdInIfNotEmpty("flint.ssl.trustStoreType", sslParams.getTrustStoreType());
                }
            }
            return this;
        }

        public Builder setClientSslParams(SslParams sslParams) {
            this.clientSslParams = sslParams;
            return this;
        }

        public Builder setSparkIOEncryption(boolean isEnabled, Integer keyLength, String algorithm) {
            this.addAppConfStdIn("spark.io.encryption.enabled", Boolean.toString(isEnabled));
            if (null != keyLength) {
                this.addAppConfStdIn("spark.io.encryption.keySizeBits", keyLength.toString());
            }
            if (null != algorithm) {
                this.addAppConfStdIn("spark.io.encryption.keygen.algorithm", algorithm);
            }
            return this;
        }

        public Builder setSparkAuthenticate(boolean isEnabled, String secret) {
            this.addAppConfStdIn("spark.authenticate", Boolean.toString(isEnabled));
            if (isEnabled) {
                if (StringUtils.isEmpty((CharSequence)secret)) {
                    throw new IllegalArgumentException("secret must be non-empty");
                }
                this.addAppConfStdIn("spark.authenticate.secret", secret);
            }
            return this;
        }

        public Builder setSparkSasl(boolean isEnabled) {
            this.addAppConfStdIn("spark.authenticate.enableSaslEncryption", Boolean.toString(isEnabled));
            this.addAppConfStdIn("spark.network.sasl.serverAlwaysEncrypt", Boolean.toString(isEnabled));
            return this;
        }

        public Builder setSparkHttps(boolean isEnabled) {
            this.addAppConfStdIn("flint.spark.https.enabled", Boolean.toString(isEnabled));
            return this;
        }

        public Builder setResultCacheEncrypted(boolean isEnabled) {
            this.addAppConfStdIn("flint.result.cache.serialize.encrypted", Boolean.toString(isEnabled));
            return this;
        }

        public Builder setNumSparkThreads(int numThreads) {
            if (numThreads <= 0) {
                throw new IllegalArgumentException("spark threads must be > 0");
            }
            this.numSparkThreads = numThreads;
            return this;
        }

        public Builder setBindHost(String host) {
            if (StringUtils.isEmpty((CharSequence)host)) {
                throw new IllegalArgumentException("bind host must be non-empty");
            }
            this.bindHost = host;
            return this;
        }

        public Builder setBindPort(int port) {
            if (port < 1 || port > 65535) {
                throw new IllegalArgumentException("bind port must be > 0 and <= 65535");
            }
            this.bindPort = port;
            this.portFile = null;
            return this;
        }

        public Builder setEphemeralBindPort(String thePortFile) {
            if (StringUtils.isEmpty((CharSequence)thePortFile)) {
                throw new IllegalArgumentException("port file must be non-empty");
            }
            this.bindPort = 0;
            this.portFile = thePortFile;
            return this;
        }

        public Builder setClientTimeout(int timeout) {
            if (timeout < 1) {
                throw new IllegalArgumentException("timeout must be > 0");
            }
            this.clientTimeout = timeout;
            return this;
        }

        public Builder setMinWorkers(int numWorkers) {
            if (numWorkers < 1) {
                throw new IllegalArgumentException("min workers must be > 1");
            }
            this.minWorkers = numWorkers;
            return this;
        }

        public Builder setMaxWorkers(int numWorkers) {
            if (numWorkers < 1) {
                throw new IllegalArgumentException("max workers must be > 1");
            }
            this.maxWorkers = numWorkers;
            return this;
        }

        public Builder setDisableSparkUI(boolean isDisabled) {
            this.disableSparkUI = isDisabled;
            return this;
        }

        public Builder setScratchDir(String path) {
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw new IllegalArgumentException("scratch directory must be non-empty");
            }
            this.scratchDir = path;
            return this;
        }

        public Builder setBuffersDir(String path) {
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw new IllegalArgumentException("buffers directory must be non-empty");
            }
            this.buffersDir = path;
            return this;
        }

        public Builder setResultCacheDir(String path) {
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw new IllegalArgumentException("resultCache directory must be non-empty");
            }
            this.resultCacheDir = path;
            return this;
        }

        public Builder setWarehouseDir(String path) {
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw new IllegalArgumentException("warehouse directory must be non-empty");
            }
            this.warehouseDir = path;
            return this;
        }

        public Builder setMetricsNS(String namespace) {
            if (StringUtils.isEmpty((CharSequence)namespace)) {
                throw new IllegalArgumentException("metric namespace must be non-empty");
            }
            this.metricsNS = namespace;
            return this;
        }

        public Builder setMetricsConfFile(String path) {
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw new IllegalArgumentException("metrics conf file must be non-empty");
            }
            this.metricsConfFile = path;
            return this;
        }

        public Builder setLog4jConfFile(String path) {
            if (StringUtils.isEmpty((CharSequence)path)) {
                throw new IllegalArgumentException("log4j conf file must be non-empty");
            }
            this.log4jConfFile = path.startsWith("file:") ? path : Paths.get(path, new String[0]).toAbsolutePath().normalize().toUri().toString();
            return this;
        }

        public Builder setKeepAliveByStdIn(boolean isKeepAliveByStdIn) {
            this.keepAliveByStdIn = isKeepAliveByStdIn;
            return this;
        }

        public Builder setQuiet(boolean isQuiet) {
            this.quiet = isQuiet;
            return this;
        }

        public Builder setLoggingOverStdOut(boolean isLoggingOverStdOut) {
            this.loggingOverStdOut = isLoggingOverStdOut;
            return this;
        }

        public Builder setEnvironmentVariables(Map<String, String> envVariables) {
            this.environmentVariables.putAll(envVariables);
            return this;
        }

        public JavaProcessLauncher build() {
            ArrayList<String> commandArgs = new ArrayList<String>();
            commandArgs.add(this.javaExecPath().toString());
            if (-1 != this.minHeapMB) {
                commandArgs.add("-Xms" + this.minHeapMB + "m");
            }
            if (-1 != this.maxHeapMB) {
                commandArgs.add("-Xmx" + this.maxHeapMB + "m");
            }
            commandArgs.add("-XX:MaxDirectMemorySize=" + this.maxDirectMB + "m");
            commandArgs.addAll(this.extraJavaOptions);
            for (String string : this.javaAgents) {
                commandArgs.add("-javaagent:" + string);
            }
            if (null != this.log4jConfFile) {
                commandArgs.add("-Dlog4j.configuration=" + this.log4jConfFile);
            }
            commandArgs.add("-Dspark.master=" + this.masterUrl());
            if (null != this.warehouseDir) {
                commandArgs.add("-Dspark.sql.warehouse.dir=" + this.warehouseDir);
            }
            for (Map.Entry entry : this.extraSysProps.entrySet()) {
                commandArgs.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
            commandArgs.add("-cp");
            commandArgs.add(this.classPath());
            commandArgs.add(JavaProcessLauncher.FLINT_SERVER_APP_MAIN_CLASS);
            for (String string : this.appConfFiles) {
                commandArgs.add("-appConf");
                commandArgs.add("\"" + string + "\"");
            }
            if (!this.appConfStdIn.isEmpty()) {
                commandArgs.add("-appConfStdIn");
            }
            if (this.quiet || this.loggingOverStdOut) {
                commandArgs.add("-quiet");
            }
            commandArgs.add("-host");
            commandArgs.add(this.bindHost);
            commandArgs.add("-port");
            commandArgs.add(Integer.toString(this.bindPort));
            if (0 == this.bindPort) {
                commandArgs.add("-portFile");
                commandArgs.add("\"" + this.portFile + "\"");
            }
            if (-1 != this.clientTimeout) {
                commandArgs.add("-clientTimeout");
                commandArgs.add(Integer.toString(this.clientTimeout));
            }
            if (-1 != this.minWorkers) {
                commandArgs.add("-minWorkers");
                commandArgs.add(Integer.toString(this.minWorkers));
            }
            if (-1 != this.maxWorkers) {
                commandArgs.add("-maxWorkers");
                commandArgs.add(Integer.toString(this.maxWorkers));
            }
            if (null != this.scratchDir) {
                commandArgs.add("-scratchDir");
                commandArgs.add("\"" + this.scratchDir + "\"");
            }
            if (null != this.buffersDir) {
                commandArgs.add("-buffersDir");
                commandArgs.add("\"" + this.buffersDir + "\"");
            }
            if (null != this.resultCacheDir) {
                commandArgs.add("-resultCacheDir");
                commandArgs.add("\"" + this.resultCacheDir + "\"");
            }
            if (null != this.metricsNS) {
                commandArgs.add("-metricsNS");
                commandArgs.add(this.metricsNS);
            }
            if (null != this.metricsConfFile) {
                commandArgs.add("-metricsConf");
                commandArgs.add("\"" + this.metricsConfFile + "\"");
            }
            if (this.disableSparkUI) {
                commandArgs.add("-disableSparkUI");
            }
            if (this.keepAliveByStdIn) {
                commandArgs.add("-keepAliveByStdIn");
            }
            return new JavaProcessLauncher(this.bindHost, this.bindPort, this.portFile, this.clientSslParams, commandArgs, this.appConfStdIn, this.environmentVariables, this.loggingOverStdOut);
        }

        private Path javaExecPath() {
            if (SystemUtils.IS_OS_WINDOWS) {
                return Paths.get(this.javaHome(), "bin/java.exe");
            }
            return Paths.get(this.javaHome(), "bin/java");
        }

        private String javaHome() {
            if (null != this.javaHome) {
                return this.javaHome;
            }
            return System.getProperty("java.home");
        }

        private String classPath() {
            StringBuilder sb = new StringBuilder();
            String sep = Builder.classPathSep();
            sb.append(this.jarPath);
            for (String path : this.extraClasspath) {
                sb.append(sep);
                sb.append(path);
            }
            return sb.toString();
        }

        private String masterUrl() {
            if (this.numSparkThreads <= 0) {
                return "local[*]";
            }
            return String.format("local[%d]", this.numSparkThreads);
        }
    }
}

