/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.launcher.logging;

import com.ibm.ba.flint.launcher.logging.JsonEventReader;
import com.ibm.ba.flint.launcher.logging.LogEvent;
import com.ibm.ba.flint.launcher.logging.LogEventHandler;
import java.io.IOException;

public class JsonEventProcessor
implements AutoCloseable {
    private final JsonEventReader reader;
    private final LogEventHandler handler;
    private volatile boolean closed = false;

    public JsonEventProcessor(JsonEventReader theReader, LogEventHandler theHandler) {
        if (null == theReader) {
            throw new NullPointerException("theReader was null");
        }
        if (null == theHandler) {
            throw new NullPointerException("theHandler was null");
        }
        this.reader = theReader;
        this.handler = theHandler;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void process() throws IOException {
        while (!this.closed) {
            LogEvent event = this.reader.read();
            if (null == event) {
                return;
            }
            this.handler.handleEvent(event);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.reader.close();
    }
}

