/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.Preconditions;
import org.apache.parquet.hadoop.codec.CleanUtil;
import org.apache.parquet.hadoop.codec.SnappyUtil;
import org.xerial.snappy.Snappy;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.io.compress.Compressor;

public class SnappyCompressor
implements Compressor {
    private ByteBuffer outputBuffer = ByteBuffer.allocateDirect(0);
    private ByteBuffer inputBuffer = ByteBuffer.allocateDirect(0);
    private long bytesRead = 0L;
    private long bytesWritten = 0L;
    private boolean finishCalled = false;

    @Override
    public synchronized int compress(byte[] buffer, int off, int len) throws IOException {
        SnappyUtil.validateBuffer(buffer, off, len);
        if (this.needsInput()) {
            return 0;
        }
        if (!this.outputBuffer.hasRemaining()) {
            int maxOutputSize = Snappy.maxCompressedLength((int)this.inputBuffer.position());
            if (maxOutputSize > this.outputBuffer.capacity()) {
                ByteBuffer oldBuffer = this.outputBuffer;
                this.outputBuffer = ByteBuffer.allocateDirect(maxOutputSize);
                CleanUtil.cleanDirectBuffer(oldBuffer);
            }
            this.outputBuffer.clear();
            this.inputBuffer.limit(this.inputBuffer.position());
            this.inputBuffer.position(0);
            int size = Snappy.compress((ByteBuffer)this.inputBuffer, (ByteBuffer)this.outputBuffer);
            this.outputBuffer.limit(size);
            this.inputBuffer.limit(0);
            this.inputBuffer.rewind();
        }
        int numBytes = Math.min(len, this.outputBuffer.remaining());
        this.outputBuffer.get(buffer, off, numBytes);
        this.bytesWritten += (long)numBytes;
        return numBytes;
    }

    @Override
    public synchronized void setInput(byte[] buffer, int off, int len) {
        SnappyUtil.validateBuffer(buffer, off, len);
        Preconditions.checkArgument(!this.outputBuffer.hasRemaining(), "Output buffer should be empty. Caller must call compress()");
        if (this.inputBuffer.capacity() - this.inputBuffer.position() < len) {
            ByteBuffer tmp = ByteBuffer.allocateDirect(this.inputBuffer.position() + len);
            this.inputBuffer.rewind();
            tmp.put(this.inputBuffer);
            ByteBuffer oldBuffer = this.inputBuffer;
            this.inputBuffer = tmp;
            CleanUtil.cleanDirectBuffer(oldBuffer);
        } else {
            this.inputBuffer.limit(this.inputBuffer.position() + len);
        }
        this.inputBuffer.put(buffer, off, len);
        this.bytesRead += (long)len;
    }

    @Override
    public void end() {
        CleanUtil.cleanDirectBuffer(this.inputBuffer);
        CleanUtil.cleanDirectBuffer(this.outputBuffer);
    }

    @Override
    public synchronized void finish() {
        this.finishCalled = true;
    }

    @Override
    public synchronized boolean finished() {
        return this.finishCalled && this.inputBuffer.position() == 0 && !this.outputBuffer.hasRemaining();
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public synchronized boolean needsInput() {
        return !this.finishCalled;
    }

    @Override
    public void reinit(Configuration c) {
        this.reset();
    }

    @Override
    public synchronized void reset() {
        this.finishCalled = false;
        this.bytesWritten = 0L;
        this.bytesRead = 0L;
        this.inputBuffer.rewind();
        this.outputBuffer.rewind();
        this.inputBuffer.limit(0);
        this.outputBuffer.limit(0);
    }

    @Override
    public void setDictionary(byte[] dictionary, int off, int len) {
    }
}

