/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;

public class ColumnPruner {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnPruner.class);

    public void pruneColumns(Configuration conf, Path inputFile, Path outputFile, List<String> cols) throws IOException {
        Set<ColumnPath> prunePaths = this.convertToColumnPaths(cols);
        ParquetMetadata pmd = ParquetFileReader.readFooter(conf, inputFile, ParquetMetadataConverter.NO_FILTER);
        FileMetaData metaData = pmd.getFileMetaData();
        MessageType schema = metaData.getSchema();
        ArrayList<String> paths = new ArrayList<String>();
        this.getPaths((GroupType)schema, paths, null);
        for (String col : cols) {
            if (paths.contains(col)) continue;
            LOG.warn("Input column name {} doesn't show up in the schema of file {}", (Object)col, (Object)inputFile.getName());
        }
        ParquetFileWriter writer = new ParquetFileWriter(conf, this.pruneColumnsInSchema(schema, prunePaths), outputFile, ParquetFileWriter.Mode.CREATE);
        writer.start();
        writer.appendFile(HadoopInputFile.fromPath(inputFile, conf));
        writer.end(metaData.getKeyValueMetaData());
    }

    private void getPaths(GroupType schema, List<String> paths, String parent) {
        List fields = schema.getFields();
        String prefix = parent == null ? "" : parent + ".";
        for (Type field : fields) {
            paths.add(prefix + field.getName());
            if (!(field instanceof GroupType)) continue;
            this.getPaths(field.asGroupType(), paths, prefix + field.getName());
        }
    }

    private MessageType pruneColumnsInSchema(MessageType schema, Set<ColumnPath> prunePaths) {
        List fields = schema.getFields();
        ArrayList<String> currentPath = new ArrayList<String>();
        List<Type> prunedFields = this.pruneColumnsInFields(fields, currentPath, prunePaths);
        MessageType newSchema = new MessageType(schema.getName(), prunedFields);
        return newSchema;
    }

    private List<Type> pruneColumnsInFields(List<Type> fields, List<String> currentPath, Set<ColumnPath> prunePaths) {
        ArrayList<Type> prunedFields = new ArrayList<Type>();
        for (Type childField : fields) {
            Type prunedChildField = this.pruneColumnsInField(childField, currentPath, prunePaths);
            if (prunedChildField == null) continue;
            prunedFields.add(prunedChildField);
        }
        return prunedFields;
    }

    private Type pruneColumnsInField(Type field, List<String> currentPath, Set<ColumnPath> prunePaths) {
        String fieldName = field.getName();
        currentPath.add(fieldName);
        ColumnPath path = ColumnPath.get(currentPath.toArray(new String[0]));
        Type prunedField = null;
        if (!prunePaths.contains(path)) {
            if (field.isPrimitive()) {
                prunedField = field;
            } else {
                List childFields = ((GroupType)field).getFields();
                List<Type> prunedFields = this.pruneColumnsInFields(childFields, currentPath, prunePaths);
                if (prunedFields.size() > 0) {
                    prunedField = ((GroupType)field).withNewFields(prunedFields);
                }
            }
        }
        currentPath.remove(fieldName);
        return prunedField;
    }

    private Set<ColumnPath> convertToColumnPaths(List<String> cols) {
        HashSet<ColumnPath> prunePaths = new HashSet<ColumnPath>();
        for (String col : cols) {
            prunePaths.add(ColumnPath.fromDotString(col));
        }
        return prunePaths;
    }
}

