/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util.counters.mapred;

import org.apache.parquet.hadoop.util.counters.BenchmarkCounter;
import org.apache.parquet.hadoop.util.counters.CounterLoader;
import org.apache.parquet.hadoop.util.counters.ICounter;
import org.apache.parquet.hadoop.util.counters.mapred.MapRedCounterAdapter;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.mapred.Counters;
import shaded.org.apache.hadoop.mapred.Reporter;

public class MapRedCounterLoader
implements CounterLoader {
    private Reporter reporter;
    private Configuration conf;

    public MapRedCounterLoader(Reporter reporter, Configuration conf) {
        this.reporter = reporter;
        this.conf = conf;
    }

    @Override
    public ICounter getCounterByNameAndFlag(String groupName, String counterName, String counterFlag) {
        Counters.Counter counter;
        if (this.conf.getBoolean(counterFlag, true) && (counter = this.reporter.getCounter(groupName, counterName)) != null) {
            return new MapRedCounterAdapter(this.reporter.getCounter(groupName, counterName));
        }
        return new BenchmarkCounter.NullCounter();
    }
}

