/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.FileAlreadyExistsException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum CreateFlag {
    CREATE(1),
    OVERWRITE(2),
    APPEND(4),
    SYNC_BLOCK(8),
    LAZY_PERSIST(16),
    NEW_BLOCK(32),
    NO_LOCAL_WRITE(64);

    private final short mode;

    private CreateFlag(short mode) {
        this.mode = mode;
    }

    short getMode() {
        return this.mode;
    }

    public static void validate(EnumSet<CreateFlag> flag) {
        if (flag == null || flag.isEmpty()) {
            throw new HadoopIllegalArgumentException(flag + " does not specify any options");
        }
        boolean append = flag.contains((Object)APPEND);
        boolean overwrite = flag.contains((Object)OVERWRITE);
        if (append && overwrite) {
            throw new HadoopIllegalArgumentException(flag + "Both append and overwrite options cannot be enabled.");
        }
    }

    public static void validate(Object path, boolean pathExists, EnumSet<CreateFlag> flag) throws IOException {
        CreateFlag.validate(flag);
        boolean append = flag.contains((Object)APPEND);
        boolean overwrite = flag.contains((Object)OVERWRITE);
        if (pathExists) {
            if (!append && !overwrite) {
                throw new FileAlreadyExistsException("File already exists: " + path.toString() + ". Append or overwrite option must be specified in " + flag);
            }
        } else if (!flag.contains((Object)CREATE)) {
            throw new FileNotFoundException("Non existing file: " + path.toString() + ". Create option is not specified in " + flag);
        }
    }

    public static void validateForAppend(EnumSet<CreateFlag> flag) {
        CreateFlag.validate(flag);
        if (!flag.contains((Object)APPEND)) {
            throw new HadoopIllegalArgumentException(flag + " does not contain APPEND");
        }
    }
}

