/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs;

import com.google.common.annotations.VisibleForTesting;
import org.apache.htrace.core.Tracer;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.tracing.TraceUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class FsTracer {
    private static Tracer instance;

    public static synchronized Tracer get(Configuration conf) {
        if (instance == null) {
            instance = new Tracer.Builder("FSClient").conf(TraceUtils.wrapHadoopConf("fs.client.htrace.", conf)).build();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static synchronized void clear() {
        if (instance == null) {
            return;
        }
        try {
            instance.close();
        }
        finally {
            instance = null;
        }
    }

    private FsTracer() {
    }
}

