/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs.permission;

import java.util.regex.Pattern;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.permission.PermissionParser;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class UmaskParser
extends PermissionParser {
    private static Pattern chmodOctalPattern = Pattern.compile("^\\s*[+]?(0*)([0-7]{3})\\s*$");
    private static Pattern umaskSymbolicPattern = Pattern.compile("\\G\\s*([ugoa]*)([+=-]+)([rwx]*)([,\\s]*)\\s*");
    final short umaskMode = (short)this.combineModes(0, false);

    public UmaskParser(String modeStr) throws IllegalArgumentException {
        super(modeStr, umaskSymbolicPattern, chmodOctalPattern);
    }

    public short getUMask() {
        if (this.symbolic) {
            return (short)(~this.umaskMode & 0x1FF);
        }
        return this.umaskMode;
    }
}

