/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.FileStatus;
import shaded.org.apache.hadoop.fs.shell.CommandFactory;
import shaded.org.apache.hadoop.fs.shell.CommandFormat;
import shaded.org.apache.hadoop.fs.shell.FsCommand;
import shaded.org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Stat
extends FsCommand {
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String NAME = "stat";
    public static final String USAGE = "[format] <path> ...";
    public static final String DESCRIPTION = "Print statistics about the file/directory at <path>" + NEWLINE + "in the specified format. Format accepts permissions in" + NEWLINE + "octal (%a) and symbolic (%A), filesize in" + NEWLINE + "bytes (%b), type (%F), group name of owner (%g)," + NEWLINE + "name (%n), block size (%o), replication (%r), user name" + NEWLINE + "of owner (%u), access date (%x, %X)." + NEWLINE + "modification date (%y, %Y)." + NEWLINE + "%x and %y show UTC date as \"yyyy-MM-dd HH:mm:ss\" and" + NEWLINE + "%X and %Y show milliseconds since January 1, 1970 UTC." + NEWLINE + "If the format is not specified, %y is used by default." + NEWLINE;
    protected final SimpleDateFormat timeFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected String format;

    Stat() {
        this.timeFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.format = "%y";
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Stat.class, "-stat");
    }

    @Override
    protected void processOptions(LinkedList<String> args) throws IOException {
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "R");
        cf.parse(args);
        this.setRecursive(cf.getOpt("R"));
        if (args.getFirst().contains("%")) {
            this.format = args.removeFirst();
        }
        cf.parse(args);
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        FileStatus stat = item.stat;
        StringBuilder buf = new StringBuilder();
        char[] fmt = this.format.toCharArray();
        block15: for (int i = 0; i < fmt.length; ++i) {
            if (fmt[i] != '%') {
                buf.append(fmt[i]);
                continue;
            }
            if (i + 1 == fmt.length) break;
            switch (fmt[++i]) {
                case 'a': {
                    buf.append(stat.getPermission().toOctal());
                    continue block15;
                }
                case 'A': {
                    buf.append(stat.getPermission());
                    continue block15;
                }
                case 'b': {
                    buf.append(stat.getLen());
                    continue block15;
                }
                case 'F': {
                    buf.append(stat.isDirectory() ? "directory" : (stat.isFile() ? "regular file" : "symlink"));
                    continue block15;
                }
                case 'g': {
                    buf.append(stat.getGroup());
                    continue block15;
                }
                case 'n': {
                    buf.append(item.path.getName());
                    continue block15;
                }
                case 'o': {
                    buf.append(stat.getBlockSize());
                    continue block15;
                }
                case 'r': {
                    buf.append(stat.getReplication());
                    continue block15;
                }
                case 'u': {
                    buf.append(stat.getOwner());
                    continue block15;
                }
                case 'x': {
                    buf.append(this.timeFmt.format(new Date(stat.getAccessTime())));
                    continue block15;
                }
                case 'X': {
                    buf.append(stat.getAccessTime());
                    continue block15;
                }
                case 'y': {
                    buf.append(this.timeFmt.format(new Date(stat.getModificationTime())));
                    continue block15;
                }
                case 'Y': {
                    buf.append(stat.getModificationTime());
                    continue block15;
                }
                default: {
                    buf.append(fmt[i]);
                }
            }
        }
        this.out.println(buf.toString());
    }
}

