/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.ha;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.ha.BadFencingConfigurationException;
import shaded.org.apache.hadoop.ha.HAServiceProtocol;
import shaded.org.apache.hadoop.ha.NodeFencer;
import shaded.org.apache.hadoop.ha.ZKFCProtocol;
import shaded.org.apache.hadoop.ha.protocolPB.HAServiceProtocolClientSideTranslatorPB;
import shaded.org.apache.hadoop.ha.protocolPB.ZKFCProtocolClientSideTranslatorPB;
import shaded.org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class HAServiceTarget {
    private static final String HOST_SUBST_KEY = "host";
    private static final String PORT_SUBST_KEY = "port";
    private static final String ADDRESS_SUBST_KEY = "address";
    private HAServiceProtocol.HAServiceState transitionTargetHAStatus;

    public abstract InetSocketAddress getAddress();

    public InetSocketAddress getHealthMonitorAddress() {
        return null;
    }

    public abstract InetSocketAddress getZKFCAddress();

    public abstract NodeFencer getFencer();

    public abstract void checkFencingConfigured() throws BadFencingConfigurationException;

    public HAServiceProtocol getProxy(Configuration conf, int timeoutMs) throws IOException {
        return this.getProxyForAddress(conf, timeoutMs, this.getAddress());
    }

    public void setTransitionTargetHAStatus(HAServiceProtocol.HAServiceState status) {
        this.transitionTargetHAStatus = status;
    }

    public HAServiceProtocol.HAServiceState getTransitionTargetHAStatus() {
        return this.transitionTargetHAStatus;
    }

    public HAServiceProtocol getHealthMonitorProxy(Configuration conf, int timeoutMs) throws IOException {
        InetSocketAddress addr = this.getHealthMonitorAddress();
        if (addr == null) {
            addr = this.getAddress();
        }
        return this.getProxyForAddress(conf, timeoutMs, addr);
    }

    private HAServiceProtocol getProxyForAddress(Configuration conf, int timeoutMs, InetSocketAddress addr) throws IOException {
        Configuration confCopy = new Configuration(conf);
        confCopy.setInt("ipc.client.connect.max.retries", 1);
        SocketFactory factory = NetUtils.getDefaultSocketFactory(confCopy);
        return new HAServiceProtocolClientSideTranslatorPB(addr, confCopy, factory, timeoutMs);
    }

    public ZKFCProtocol getZKFCProxy(Configuration conf, int timeoutMs) throws IOException {
        Configuration confCopy = new Configuration(conf);
        confCopy.setInt("ipc.client.connect.max.retries", 1);
        SocketFactory factory = NetUtils.getDefaultSocketFactory(confCopy);
        return new ZKFCProtocolClientSideTranslatorPB(this.getZKFCAddress(), confCopy, factory, timeoutMs);
    }

    public final Map<String, String> getFencingParameters() {
        HashMap ret = Maps.newHashMap();
        this.addFencingParameters(ret);
        return ret;
    }

    protected void addFencingParameters(Map<String, String> ret) {
        ret.put(ADDRESS_SUBST_KEY, String.valueOf(this.getAddress()));
        ret.put(HOST_SUBST_KEY, this.getAddress().getHostName());
        ret.put(PORT_SUBST_KEY, String.valueOf(this.getAddress().getPort()));
    }

    public boolean isAutoFailoverEnabled() {
        return false;
    }

    public boolean supportObserver() {
        return false;
    }
}

