/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.hdfs.protocol.proto.DatanodeLifelineProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.PBHelper;
import shaded.org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import shaded.org.apache.hadoop.hdfs.server.protocol.DatanodeLifelineProtocol;
import shaded.org.apache.hadoop.hdfs.server.protocol.StorageReport;
import shaded.org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;

@InterfaceAudience.Private
public class DatanodeLifelineProtocolServerSideTranslatorPB
implements DatanodeLifelineProtocolPB {
    private static final DatanodeLifelineProtocolProtos.LifelineResponseProto VOID_LIFELINE_RESPONSE_PROTO = DatanodeLifelineProtocolProtos.LifelineResponseProto.newBuilder().build();
    private final DatanodeLifelineProtocol impl;

    public DatanodeLifelineProtocolServerSideTranslatorPB(DatanodeLifelineProtocol impl) {
        this.impl = impl;
    }

    @Override
    public DatanodeLifelineProtocolProtos.LifelineResponseProto sendLifeline(RpcController controller, DatanodeProtocolProtos.HeartbeatRequestProto request) throws ServiceException {
        try {
            StorageReport[] report = PBHelperClient.convertStorageReports(request.getReportsList());
            VolumeFailureSummary volumeFailureSummary = request.hasVolumeFailureSummary() ? PBHelper.convertVolumeFailureSummary(request.getVolumeFailureSummary()) : null;
            this.impl.sendLifeline(PBHelper.convert(request.getRegistration()), report, request.getCacheCapacity(), request.getCacheUsed(), request.getXmitsInProgress(), request.getXceiverCount(), request.getFailedVolumes(), volumeFailureSummary);
            return VOID_LIFELINE_RESPONSE_PROTO;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

