/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.hdfs.protocol.Block;
import shaded.org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import shaded.org.apache.hadoop.hdfs.protocol.proto.InterDatanodeProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocolPB.InterDatanodeProtocolPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.PBHelper;
import shaded.org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import shaded.org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import shaded.org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import shaded.org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;

@InterfaceAudience.Private
public class InterDatanodeProtocolServerSideTranslatorPB
implements InterDatanodeProtocolPB {
    private final InterDatanodeProtocol impl;

    public InterDatanodeProtocolServerSideTranslatorPB(InterDatanodeProtocol impl) {
        this.impl = impl;
    }

    @Override
    public InterDatanodeProtocolProtos.InitReplicaRecoveryResponseProto initReplicaRecovery(RpcController unused, InterDatanodeProtocolProtos.InitReplicaRecoveryRequestProto request) throws ServiceException {
        ReplicaRecoveryInfo r;
        BlockRecoveryCommand.RecoveringBlock b = PBHelper.convert(request.getBlock());
        try {
            r = this.impl.initReplicaRecovery(b);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        if (r == null) {
            return InterDatanodeProtocolProtos.InitReplicaRecoveryResponseProto.newBuilder().setReplicaFound(false).build();
        }
        return InterDatanodeProtocolProtos.InitReplicaRecoveryResponseProto.newBuilder().setReplicaFound(true).setBlock(PBHelperClient.convert((Block)r)).setState(PBHelper.convert(r.getOriginalReplicaState())).build();
    }

    @Override
    public InterDatanodeProtocolProtos.UpdateReplicaUnderRecoveryResponseProto updateReplicaUnderRecovery(RpcController unused, InterDatanodeProtocolProtos.UpdateReplicaUnderRecoveryRequestProto request) throws ServiceException {
        String storageID;
        try {
            storageID = this.impl.updateReplicaUnderRecovery(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)request.getBlock()), request.getRecoveryId(), request.getNewBlockId(), request.getNewLength());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return InterDatanodeProtocolProtos.UpdateReplicaUnderRecoveryResponseProto.newBuilder().setStorageUuid(storageID).build();
    }
}

