/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.hdfs.protocol.proto.JournalProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocolPB.JournalProtocolPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.PBHelper;
import shaded.org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import shaded.org.apache.hadoop.hdfs.server.protocol.FenceResponse;
import shaded.org.apache.hadoop.hdfs.server.protocol.JournalInfo;
import shaded.org.apache.hadoop.hdfs.server.protocol.JournalProtocol;
import shaded.org.apache.hadoop.ipc.ProtobufHelper;
import shaded.org.apache.hadoop.ipc.ProtocolMetaInterface;
import shaded.org.apache.hadoop.ipc.RPC;
import shaded.org.apache.hadoop.ipc.RpcClientUtil;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class JournalProtocolTranslatorPB
implements ProtocolMetaInterface,
JournalProtocol,
Closeable {
    private static final RpcController NULL_CONTROLLER = null;
    private final JournalProtocolPB rpcProxy;

    public JournalProtocolTranslatorPB(JournalProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public void journal(JournalInfo journalInfo, long epoch, long firstTxnId, int numTxns, byte[] records) throws IOException {
        JournalProtocolProtos.JournalRequestProto req = JournalProtocolProtos.JournalRequestProto.newBuilder().setJournalInfo(PBHelper.convert(journalInfo)).setEpoch(epoch).setFirstTxnId(firstTxnId).setNumTxns(numTxns).setRecords(PBHelperClient.getByteString((byte[])records)).build();
        try {
            this.rpcProxy.journal(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void startLogSegment(JournalInfo journalInfo, long epoch, long txid) throws IOException {
        JournalProtocolProtos.StartLogSegmentRequestProto req = JournalProtocolProtos.StartLogSegmentRequestProto.newBuilder().setJournalInfo(PBHelper.convert(journalInfo)).setEpoch(epoch).setTxid(txid).build();
        try {
            this.rpcProxy.startLogSegment(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public FenceResponse fence(JournalInfo journalInfo, long epoch, String fencerInfo) throws IOException {
        JournalProtocolProtos.FenceRequestProto req = JournalProtocolProtos.FenceRequestProto.newBuilder().setEpoch(epoch).setJournalInfo(PBHelper.convert(journalInfo)).build();
        try {
            JournalProtocolProtos.FenceResponseProto resp = this.rpcProxy.fence(NULL_CONTROLLER, req);
            return new FenceResponse(resp.getPreviousEpoch(), resp.getLastTransactionId(), resp.getInSync());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported(this.rpcProxy, JournalProtocolPB.class, RPC.RpcKind.RPC_PROTOCOL_BUFFER, RPC.getProtocolVersion(JournalProtocolPB.class), methodName);
    }
}

