/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shaded.org.apache.hadoop.hdfs.protocol.Block;
import shaded.org.apache.hadoop.util.Time;

public class MovedBlocks<L> {
    private static final int CUR_WIN = 0;
    private static final int OLD_WIN = 1;
    private static final int NUM_WINS = 2;
    private final long winTimeInterval;
    private long lastCleanupTime = Time.monotonicNow();
    private final List<Map<Block, Locations<L>>> movedBlocks = new ArrayList<Map<Block, Locations<L>>>(2);

    public MovedBlocks(long winTimeInterval) {
        this.winTimeInterval = winTimeInterval;
        this.movedBlocks.add(this.newMap());
        this.movedBlocks.add(this.newMap());
    }

    private Map<Block, Locations<L>> newMap() {
        return new HashMap<Block, Locations<L>>();
    }

    public synchronized void put(Locations<L> block) {
        this.movedBlocks.get(0).put(block.getBlock(), block);
    }

    public synchronized boolean contains(Block block) {
        return this.movedBlocks.get(0).containsKey(block) || this.movedBlocks.get(1).containsKey(block);
    }

    public synchronized void cleanup() {
        long curTime = Time.monotonicNow();
        if (this.lastCleanupTime + this.winTimeInterval <= curTime) {
            this.movedBlocks.set(1, this.movedBlocks.get(0));
            this.movedBlocks.set(0, this.newMap());
            this.lastCleanupTime = curTime;
        }
    }

    public static class Locations<L> {
        private final Block block;
        protected final List<L> locations = new ArrayList<L>(3);

        public Locations(Block block) {
            this.block = block;
        }

        public synchronized void clearLocations() {
            this.locations.clear();
        }

        public synchronized void addLocation(L loc) {
            if (!this.locations.contains(loc)) {
                this.locations.add(loc);
            }
        }

        public synchronized boolean isLocatedOn(L loc) {
            return this.locations.contains(loc);
        }

        public synchronized List<L> getLocations() {
            return this.locations;
        }

        public Block getBlock() {
            return this.block;
        }

        public long getNumBytes() {
            return this.block.getNumBytes();
        }

        public String toString() {
            return this.block + " size=" + this.getNumBytes();
        }
    }
}

