/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import shaded.org.apache.hadoop.hdfs.protocol.Block;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.OutOfLegacyGenerationStampsException;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.SequentialBlockIdGenerator;
import shaded.org.apache.hadoop.hdfs.server.common.GenerationStamp;

public class BlockIdManager {
    private final GenerationStamp legacyGenerationStamp = new GenerationStamp();
    private final GenerationStamp generationStamp = new GenerationStamp();
    private final GenerationStamp impendingGenerationStamp = new GenerationStamp();
    private long legacyGenerationStampLimit = 0L;
    private final SequentialBlockIdGenerator blockIdGenerator;

    public BlockIdManager(BlockManager blockManager) {
        this.blockIdGenerator = new SequentialBlockIdGenerator(blockManager);
    }

    public long upgradeLegacyGenerationStamp() {
        Preconditions.checkState((this.generationStamp.getCurrentValue() == 1000L ? 1 : 0) != 0);
        this.generationStamp.skipTo(this.legacyGenerationStamp.getCurrentValue() + 0x10000000000L);
        this.legacyGenerationStampLimit = this.generationStamp.getCurrentValue();
        return this.generationStamp.getCurrentValue();
    }

    public void setLegacyGenerationStampLimit(long stamp) {
        Preconditions.checkState((this.legacyGenerationStampLimit == 0L ? 1 : 0) != 0);
        this.legacyGenerationStampLimit = stamp;
    }

    public long getGenerationStampAtblockIdSwitch() {
        return this.legacyGenerationStampLimit;
    }

    @VisibleForTesting
    SequentialBlockIdGenerator getBlockIdGenerator() {
        return this.blockIdGenerator;
    }

    public void setLastAllocatedBlockId(long blockId) {
        this.blockIdGenerator.skipTo(blockId);
    }

    public long getLastAllocatedBlockId() {
        return this.blockIdGenerator.getCurrentValue();
    }

    public void setLegacyGenerationStamp(long stamp) {
        this.legacyGenerationStamp.setCurrentValue(stamp);
    }

    public long getLegacyGenerationStamp() {
        return this.legacyGenerationStamp.getCurrentValue();
    }

    public void setGenerationStamp(long stamp) {
        this.generationStamp.setCurrentValue(stamp);
    }

    public void setImpendingGenerationStamp(long stamp) {
        this.impendingGenerationStamp.setIfGreater(stamp);
    }

    public void applyImpendingGenerationStamp() {
        this.setGenerationStampIfGreater(this.impendingGenerationStamp.getCurrentValue());
    }

    @VisibleForTesting
    public long getImpendingGenerationStamp() {
        return this.impendingGenerationStamp.getCurrentValue();
    }

    public void setGenerationStampIfGreater(long stamp) {
        this.generationStamp.setIfGreater(stamp);
    }

    public long getGenerationStamp() {
        return this.generationStamp.getCurrentValue();
    }

    long nextGenerationStamp(boolean legacyBlock) throws IOException {
        return legacyBlock ? this.getNextLegacyGenerationStamp() : this.getNextGenerationStamp();
    }

    @VisibleForTesting
    long getNextLegacyGenerationStamp() throws IOException {
        long legacyGenStamp = this.legacyGenerationStamp.nextValue();
        if (legacyGenStamp >= this.legacyGenerationStampLimit) {
            throw new OutOfLegacyGenerationStampsException();
        }
        return legacyGenStamp;
    }

    @VisibleForTesting
    long getNextGenerationStamp() {
        return this.generationStamp.nextValue();
    }

    public long getLegacyGenerationStampLimit() {
        return this.legacyGenerationStampLimit;
    }

    boolean isLegacyBlock(Block block) {
        return block.getGenerationStamp() < this.getLegacyGenerationStampLimit();
    }

    long nextBlockId() {
        return this.blockIdGenerator.nextValue();
    }

    boolean isGenStampInFuture(Block block) {
        if (this.isLegacyBlock(block)) {
            return block.getGenerationStamp() > this.getLegacyGenerationStamp();
        }
        return block.getGenerationStamp() > this.getGenerationStamp();
    }

    void clear() {
        this.legacyGenerationStamp.setCurrentValue(1000L);
        this.generationStamp.setCurrentValue(1000L);
        this.getBlockIdGenerator().setCurrentValue(0x40000000L);
        this.legacyGenerationStampLimit = 0L;
    }
}

