/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.hdfs.protocol.Block;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import shaded.org.apache.hadoop.ipc.Server;

@InterfaceAudience.Private
public class CorruptReplicasMap {
    private final Map<Block, Map<DatanodeDescriptor, Reason>> corruptReplicasMap = new HashMap<Block, Map<DatanodeDescriptor, Reason>>();

    void addToCorruptReplicasMap(Block blk, DatanodeDescriptor dn, String reason, Reason reasonCode) {
        Map<DatanodeDescriptor, Reason> nodes = this.corruptReplicasMap.get(blk);
        if (nodes == null) {
            nodes = new HashMap<DatanodeDescriptor, Reason>();
            this.corruptReplicasMap.put(blk, nodes);
        }
        String reasonText = reason != null ? " because " + reason : "";
        if (!nodes.keySet().contains((Object)dn)) {
            NameNode.blockStateChangeLog.debug("BLOCK NameSystem.addToCorruptReplicasMap: {} added as corrupt on {} by {} {}", new Object[]{blk, dn, Server.getRemoteIp(), reasonText});
        } else {
            NameNode.blockStateChangeLog.debug("BLOCK NameSystem.addToCorruptReplicasMap: duplicate requested for {} to add as corrupt on {} by {} {}", new Object[]{blk, dn, Server.getRemoteIp(), reasonText});
        }
        nodes.put(dn, reasonCode);
    }

    void removeFromCorruptReplicasMap(Block blk) {
        if (this.corruptReplicasMap != null) {
            this.corruptReplicasMap.remove(blk);
        }
    }

    boolean removeFromCorruptReplicasMap(Block blk, DatanodeDescriptor datanode) {
        return this.removeFromCorruptReplicasMap(blk, datanode, Reason.ANY);
    }

    boolean removeFromCorruptReplicasMap(Block blk, DatanodeDescriptor datanode, Reason reason) {
        Map<DatanodeDescriptor, Reason> datanodes = this.corruptReplicasMap.get(blk);
        if (datanodes == null) {
            return false;
        }
        Reason storedReason = datanodes.get((Object)datanode);
        if (reason != Reason.ANY && storedReason != null && reason != storedReason) {
            return false;
        }
        if (datanodes.remove((Object)datanode) != null) {
            if (datanodes.isEmpty()) {
                this.corruptReplicasMap.remove(blk);
            }
            return true;
        }
        return false;
    }

    Collection<DatanodeDescriptor> getNodes(Block blk) {
        Map<DatanodeDescriptor, Reason> nodes = this.corruptReplicasMap.get(blk);
        if (nodes == null) {
            return null;
        }
        return nodes.keySet();
    }

    boolean isReplicaCorrupt(Block blk, DatanodeDescriptor node) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes != null && nodes.contains((Object)node);
    }

    int numCorruptReplicas(Block blk) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes == null ? 0 : nodes.size();
    }

    int size() {
        return this.corruptReplicasMap.size();
    }

    @VisibleForTesting
    long[] getCorruptReplicaBlockIdsForTesting(int numExpectedBlocks, Long startingBlockId) {
        if (numExpectedBlocks < 0 || numExpectedBlocks > 100) {
            return null;
        }
        Iterator<Block> blockIt = new TreeMap<Block, Map<DatanodeDescriptor, Reason>>(this.corruptReplicasMap).keySet().iterator();
        if (startingBlockId != null) {
            boolean isBlockFound = false;
            while (blockIt.hasNext()) {
                Block b = blockIt.next();
                if (b.getBlockId() != startingBlockId.longValue()) continue;
                isBlockFound = true;
                break;
            }
            if (!isBlockFound) {
                return null;
            }
        }
        ArrayList<Long> corruptReplicaBlockIds = new ArrayList<Long>();
        for (int i = 0; i < numExpectedBlocks && blockIt.hasNext(); ++i) {
            corruptReplicaBlockIds.add(blockIt.next().getBlockId());
        }
        long[] ret = new long[corruptReplicaBlockIds.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Long)corruptReplicaBlockIds.get(i);
        }
        return ret;
    }

    Set<Block> getCorruptBlocks() {
        HashSet<Block> corruptBlocks = new HashSet<Block>();
        corruptBlocks.addAll(this.corruptReplicasMap.keySet());
        return corruptBlocks;
    }

    String getCorruptReason(Block block, DatanodeDescriptor node) {
        Enum reason = null;
        if (this.corruptReplicasMap.containsKey(block) && this.corruptReplicasMap.get(block).containsKey((Object)node)) {
            reason = this.corruptReplicasMap.get(block).get((Object)node);
        }
        if (reason != null) {
            return reason.toString();
        }
        return null;
    }

    public static enum Reason {
        NONE,
        ANY,
        GENSTAMP_MISMATCH,
        SIZE_MISMATCH,
        INVALID_STATE,
        CORRUPTION_REPORTED;

    }
}

