/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import shaded.org.apache.hadoop.hdfs.protocol.Block;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;

class ReplicaUnderConstruction
extends Block {
    private final DatanodeStorageInfo expectedLocation;
    private HdfsServerConstants.ReplicaState state;
    private boolean chosenAsPrimary;

    ReplicaUnderConstruction(Block block, DatanodeStorageInfo target, HdfsServerConstants.ReplicaState state) {
        super(block);
        this.expectedLocation = target;
        this.state = state;
        this.chosenAsPrimary = false;
    }

    DatanodeStorageInfo getExpectedStorageLocation() {
        return this.expectedLocation;
    }

    HdfsServerConstants.ReplicaState getState() {
        return this.state;
    }

    boolean getChosenAsPrimary() {
        return this.chosenAsPrimary;
    }

    void setState(HdfsServerConstants.ReplicaState s) {
        this.state = s;
    }

    void setChosenAsPrimary(boolean chosenAsPrimary) {
        this.chosenAsPrimary = chosenAsPrimary;
    }

    boolean isAlive() {
        return this.expectedLocation.getDatanodeDescriptor().isAlive();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(50);
        this.appendStringTo(b);
        return b.toString();
    }

    public void appendStringTo(StringBuilder sb) {
        sb.append("ReplicaUC[").append(this.expectedLocation).append("|").append((Object)this.state).append("]");
    }
}

