/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.hdfs.DFSUtilClient;
import shaded.org.apache.hadoop.hdfs.server.common.HttpGetFailedException;
import shaded.org.apache.hadoop.hdfs.server.common.Storage;
import shaded.org.apache.hadoop.hdfs.server.common.StorageErrorReporter;
import shaded.org.apache.hadoop.hdfs.util.DataTransferThrottler;
import shaded.org.apache.hadoop.hdfs.web.URLConnectionFactory;
import shaded.org.apache.hadoop.io.MD5Hash;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.security.authentication.client.AuthenticationException;
import shaded.org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public final class Util {
    private static final Log LOG = LogFactory.getLog((String)Util.class.getName());
    public static final String FILE_LENGTH = "File-Length";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String MD5_HEADER = "X-MD5-Digest";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final int IO_FILE_BUFFER_SIZE;
    private static final boolean isSpnegoEnabled;
    public static final URLConnectionFactory connectionFactory;

    static URI stringAsURI(String s) throws IOException {
        URI u = null;
        try {
            u = new URI(s);
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("Syntax error in URI " + s + ". Please check hdfs configuration."), (Throwable)e);
        }
        if (u == null || u.getScheme() == null) {
            LOG.info((Object)("Assuming 'file' scheme for path " + s + " in configuration."));
            u = Util.fileAsURI(new File(s));
        }
        return u;
    }

    public static URI fileAsURI(File f) throws IOException {
        URI u = f.getCanonicalFile().toURI();
        if (u.getPath().endsWith("/")) {
            String uriAsString = u.toString();
            try {
                u = new URI(uriAsString.substring(0, uriAsString.length() - 1));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return u;
    }

    public static List<URI> stringCollectionAsURIs(Collection<String> names) {
        ArrayList<URI> uris = new ArrayList<URI>(names.size());
        for (String name : names) {
            try {
                uris.add(Util.stringAsURI(name));
            }
            catch (IOException e) {
                LOG.error((Object)("Error while processing URI: " + name), (Throwable)e);
            }
        }
        return uris;
    }

    public static boolean isDiskStatsEnabled(int fileIOSamplingPercentage) {
        boolean isEnabled;
        if (fileIOSamplingPercentage <= 0) {
            LOG.info((Object)("dfs.datanode.fileio.profiling.sampling.percentage set to " + fileIOSamplingPercentage + ". Disabling file IO profiling"));
            isEnabled = false;
        } else {
            LOG.info((Object)("dfs.datanode.fileio.profiling.sampling.percentage set to " + fileIOSamplingPercentage + ". Enabling file IO profiling"));
            isEnabled = true;
        }
        return isEnabled;
    }

    public static MD5Hash doGetUrl(URL url, List<File> localPaths, Storage dstStorage, boolean getChecksum, int timeout) throws IOException {
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)connectionFactory.openConnection(url, isSpnegoEnabled);
        }
        catch (AuthenticationException e) {
            throw new IOException(e);
        }
        Util.setTimeout(connection, timeout);
        if (connection.getResponseCode() != 200) {
            throw new HttpGetFailedException("Image transfer servlet at " + url + " failed with status code " + connection.getResponseCode() + "\nResponse message:\n" + connection.getResponseMessage(), connection);
        }
        String contentLength = connection.getHeaderField(CONTENT_LENGTH);
        if (contentLength == null) {
            throw new IOException("Content-Length header is not provided by the namenode when trying to fetch " + url);
        }
        long advertisedSize = Long.parseLong(contentLength);
        MD5Hash advertisedDigest = Util.parseMD5Header(connection);
        String fsImageName = connection.getHeaderField("X-Image-Edits-Name");
        InputStream stream = connection.getInputStream();
        return Util.receiveFile(url.toExternalForm(), localPaths, dstStorage, getChecksum, advertisedSize, advertisedDigest, fsImageName, stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MD5Hash receiveFile(String url, List<File> localPaths, Storage dstStorage, boolean getChecksum, long advertisedSize, MD5Hash advertisedDigest, String fsImageName, InputStream stream, DataTransferThrottler throttler) throws IOException {
        long startTime = Time.monotonicNow();
        HashMap<FileOutputStream, File> streamPathMap = new HashMap<FileOutputStream, File>();
        StringBuilder xferStats = new StringBuilder();
        double xferCombined = 0.0;
        if (localPaths != null) {
            ArrayList<File> newLocalPaths = new ArrayList<File>();
            for (File localPath : localPaths) {
                if (localPath.isDirectory()) {
                    if (fsImageName == null) {
                        throw new IOException("No filename header provided by server");
                    }
                    newLocalPaths.add(new File(localPath, fsImageName));
                    continue;
                }
                newLocalPaths.add(localPath);
            }
            localPaths = newLocalPaths;
        }
        long received = 0L;
        MessageDigest digester = null;
        if (getChecksum) {
            digester = MD5Hash.getDigester();
            stream = new DigestInputStream(stream, digester);
        }
        boolean finishedReceiving = false;
        ArrayList outputStreams = Lists.newArrayList();
        try {
            if (localPaths != null) {
                for (File f : localPaths) {
                    try {
                        if (f.exists()) {
                            LOG.warn((Object)("Overwriting existing file " + f + " with file downloaded from " + url));
                        }
                        FileOutputStream fos = new FileOutputStream(f);
                        outputStreams.add(fos);
                        streamPathMap.put(fos, f);
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Unable to download file " + f), (Throwable)ioe);
                        if (dstStorage == null || !(dstStorage instanceof StorageErrorReporter)) continue;
                        ((StorageErrorReporter)((Object)dstStorage)).reportErrorOnFile(f);
                    }
                }
                if (outputStreams.isEmpty()) {
                    throw new IOException("Unable to download to any storage directory");
                }
            }
            int num = 1;
            byte[] buf = new byte[IO_FILE_BUFFER_SIZE];
            while (num > 0) {
                num = stream.read(buf);
                if (num <= 0) continue;
                received += (long)num;
                for (FileOutputStream fos : outputStreams) {
                    fos.write(buf, 0, num);
                }
                if (throttler == null) continue;
                throttler.throttle(num);
            }
            finishedReceiving = true;
            double xferSec = Math.max((double)(Time.monotonicNow() - startTime) / 1000.0, 0.001);
            long xferKb = received / 1024L;
            xferCombined += xferSec;
            xferStats.append(String.format(" The fsimage download took %.2fs at %.2f KB/s.", xferSec, (double)xferKb / xferSec));
        }
        catch (Throwable throwable) {
            stream.close();
            for (FileOutputStream fos : outputStreams) {
                long flushStartTime = Time.monotonicNow();
                fos.getChannel().force(true);
                fos.close();
                double writeSec = Math.max((double)(flushStartTime - Time.monotonicNow()) / 1000.0, 0.001);
                xferCombined += writeSec;
                xferStats.append(String.format(" Synchronous (fsync) write to disk of " + ((File)streamPathMap.get(fos)).getAbsolutePath() + " took %.2fs.", writeSec));
            }
            if (!finishedReceiving) {
                Util.deleteTmpFiles(localPaths);
            }
            if (finishedReceiving && received != advertisedSize) {
                Util.deleteTmpFiles(localPaths);
                throw new IOException("File " + url + " received length " + received + " is not of the advertised size " + advertisedSize);
            }
            throw throwable;
        }
        stream.close();
        for (FileOutputStream fos : outputStreams) {
            long flushStartTime = Time.monotonicNow();
            fos.getChannel().force(true);
            fos.close();
            double writeSec = Math.max((double)(flushStartTime - Time.monotonicNow()) / 1000.0, 0.001);
            xferCombined += writeSec;
            xferStats.append(String.format(" Synchronous (fsync) write to disk of " + ((File)streamPathMap.get(fos)).getAbsolutePath() + " took %.2fs.", writeSec));
        }
        if (!finishedReceiving) {
            Util.deleteTmpFiles(localPaths);
        }
        if (finishedReceiving && received != advertisedSize) {
            Util.deleteTmpFiles(localPaths);
            throw new IOException("File " + url + " received length " + received + " is not of the advertised size " + advertisedSize);
        }
        xferStats.insert(0, String.format("Combined time for fsimage download and fsync to all disks took %.2fs.", xferCombined));
        LOG.info((Object)xferStats.toString());
        if (digester != null) {
            MD5Hash computedDigest = new MD5Hash(digester.digest());
            if (advertisedDigest != null && !computedDigest.equals(advertisedDigest)) {
                Util.deleteTmpFiles(localPaths);
                throw new IOException("File " + url + " computed digest " + computedDigest + " does not match advertised digest " + advertisedDigest);
            }
            return computedDigest;
        }
        return null;
    }

    private static void deleteTmpFiles(List<File> files) {
        if (files == null) {
            return;
        }
        LOG.info((Object)("Deleting temporary files: " + files));
        for (File file : files) {
            if (file.delete()) continue;
            LOG.warn((Object)("Deleting " + file + " has failed"));
        }
    }

    public static void setTimeout(HttpURLConnection connection, int timeout) {
        if (timeout > 0) {
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
        }
    }

    private static MD5Hash parseMD5Header(HttpURLConnection connection) {
        String header = connection.getHeaderField(MD5_HEADER);
        return header != null ? new MD5Hash(header) : null;
    }

    static {
        Configuration conf = new Configuration();
        connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
        isSpnegoEnabled = UserGroupInformation.isSecurityEnabled();
        IO_FILE_BUFFER_SIZE = DFSUtilClient.getIoFileBufferSize((Configuration)conf);
    }
}

