/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.datanode;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.hdfs.protocol.LayoutVersion;

@InterfaceAudience.Private
public class DataNodeLayoutVersion {
    public static final Map<Integer, SortedSet<LayoutVersion.LayoutFeature>> FEATURES = new HashMap<Integer, SortedSet<LayoutVersion.LayoutFeature>>();
    public static final int CURRENT_LAYOUT_VERSION = LayoutVersion.getCurrentLayoutVersion(Feature.values());

    public static SortedSet<LayoutVersion.LayoutFeature> getFeatures(int lv) {
        return FEATURES.get(lv);
    }

    public static boolean supports(LayoutVersion.LayoutFeature f, int lv) {
        return LayoutVersion.supports(FEATURES, f, lv);
    }

    static {
        LayoutVersion.updateMap(FEATURES, LayoutVersion.Feature.values());
        LayoutVersion.updateMap(FEATURES, Feature.values());
    }

    public static enum Feature implements LayoutVersion.LayoutFeature
    {
        FIRST_LAYOUT(-55, -53, "First datanode layout", false, new Feature[0]),
        BLOCKID_BASED_LAYOUT(-56, "The block ID of a finalized block uniquely determines its position in the directory structure"),
        BLOCKID_BASED_LAYOUT_32_by_32(-57, "Identical to the block id based layout (-56) except it uses a smaller directory structure (32x32)");

        private final LayoutVersion.FeatureInfo info;

        private Feature(int lv, String description) {
            this(lv, lv + 1, description, false, new Feature[0]);
        }

        private Feature(int lv, int ancestorLV, String description, boolean reserved, Feature ... features) {
            this.info = new LayoutVersion.FeatureInfo(lv, ancestorLV, description, reserved, features);
        }

        @Override
        public LayoutVersion.FeatureInfo getInfo() {
            return this.info;
        }
    }
}

