/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import shaded.org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import shaded.org.apache.hadoop.hdfs.server.datanode.BPServiceActorAction;
import shaded.org.apache.hadoop.hdfs.server.datanode.BPServiceActorActionException;
import shaded.org.apache.hadoop.hdfs.server.datanode.DataNode;
import shaded.org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import shaded.org.apache.hadoop.ipc.RemoteException;

public class ErrorReportAction
implements BPServiceActorAction {
    final int errorCode;
    final String errorMessage;

    public ErrorReportAction(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public void reportTo(DatanodeProtocolClientSideTranslatorPB bpNamenode, DatanodeRegistration bpRegistration) throws BPServiceActorActionException {
        try {
            bpNamenode.errorReport(bpRegistration, this.errorCode, this.errorMessage);
        }
        catch (RemoteException re) {
            DataNode.LOG.info("trySendErrorReport encountered RemoteException  errorMessage: " + this.errorMessage + "  errorCode: " + this.errorCode, (Throwable)re);
        }
        catch (IOException e) {
            throw new BPServiceActorActionException("Error reporting an error to namenode.", e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.errorCode;
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ErrorReportAction)) {
            return false;
        }
        ErrorReportAction other = (ErrorReportAction)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return !(this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage));
    }
}

