/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.datanode.checker;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.hdfs.server.datanode.checker.AsyncChecker;
import shaded.org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import shaded.org.apache.hadoop.hdfs.server.datanode.checker.TimeoutFuture;
import shaded.org.apache.hadoop.util.Timer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ThrottledAsyncChecker<K, V>
implements AsyncChecker<K, V> {
    public static final Logger LOG = LoggerFactory.getLogger(ThrottledAsyncChecker.class);
    private final Timer timer;
    private final ListeningExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final long minMsBetweenChecks;
    private final long diskCheckTimeout;
    private final Map<Checkable, ListenableFuture<V>> checksInProgress;
    private final Map<Checkable, LastCheckResult<V>> completedChecks;

    ThrottledAsyncChecker(Timer timer, long minMsBetweenChecks, long diskCheckTimeout, ExecutorService executorService) {
        this.timer = timer;
        this.minMsBetweenChecks = minMsBetweenChecks;
        this.diskCheckTimeout = diskCheckTimeout;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
        this.checksInProgress = new HashMap<Checkable, ListenableFuture<V>>();
        this.completedChecks = new WeakHashMap<Checkable, LastCheckResult<V>>();
        if (this.diskCheckTimeout > 0L) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
            this.scheduledExecutorService = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)scheduledThreadPoolExecutor);
        } else {
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public Optional<ListenableFuture<V>> schedule(final Checkable<K, V> target, final K context) {
        LOG.info("Scheduling a check for {}", target);
        if (this.checksInProgress.containsKey(target)) {
            return Optional.absent();
        }
        if (this.completedChecks.containsKey(target)) {
            LastCheckResult<V> result = this.completedChecks.get(target);
            long msSinceLastCheck = this.timer.monotonicNow() - ((LastCheckResult)result).completedAt;
            if (msSinceLastCheck < this.minMsBetweenChecks) {
                LOG.debug("Skipped checking {}. Time since last check {}ms is less than the min gap {}ms.", new Object[]{target, msSinceLastCheck, this.minMsBetweenChecks});
                return Optional.absent();
            }
        }
        ListenableFuture lfWithoutTimeout = this.executorService.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return target.check(context);
            }
        });
        ListenableFuture lf = this.diskCheckTimeout > 0L ? TimeoutFuture.create(lfWithoutTimeout, this.diskCheckTimeout, TimeUnit.MILLISECONDS, this.scheduledExecutorService) : lfWithoutTimeout;
        this.checksInProgress.put(target, lf);
        this.addResultCachingCallback(target, lf);
        return Optional.of(lf);
    }

    private void addResultCachingCallback(final Checkable<K, V> target, ListenableFuture<V> lf) {
        Futures.addCallback(lf, (FutureCallback)new FutureCallback<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(@Nullable V result) {
                ThrottledAsyncChecker throttledAsyncChecker = ThrottledAsyncChecker.this;
                synchronized (throttledAsyncChecker) {
                    ThrottledAsyncChecker.this.checksInProgress.remove(target);
                    ThrottledAsyncChecker.this.completedChecks.put(target, new LastCheckResult(result, ThrottledAsyncChecker.this.timer.monotonicNow()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(@Nonnull Throwable t) {
                ThrottledAsyncChecker throttledAsyncChecker = ThrottledAsyncChecker.this;
                synchronized (throttledAsyncChecker) {
                    ThrottledAsyncChecker.this.checksInProgress.remove(target);
                    ThrottledAsyncChecker.this.completedChecks.put(target, new LastCheckResult(t, ThrottledAsyncChecker.this.timer.monotonicNow()));
                }
            }
        });
    }

    @Override
    public void shutdownAndWait(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService.awaitTermination(timeout, timeUnit);
        }
        this.executorService.shutdownNow();
        this.executorService.awaitTermination(timeout, timeUnit);
    }

    private static final class LastCheckResult<V> {
        private final long completedAt;
        @Nullable
        private final V result;
        private final Throwable exception;

        private LastCheckResult(V result, long completedAt) {
            this.result = result;
            this.exception = null;
            this.completedAt = completedAt;
        }

        private LastCheckResult(Throwable t, long completedAt) {
            this.result = null;
            this.exception = t;
            this.completedAt = completedAt;
        }
    }
}

