/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.datanode.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OutlierDetector {
    public static final Logger LOG = LoggerFactory.getLogger(OutlierDetector.class);
    private final long minNumResources;
    private static final double MAD_MULTIPLIER = 1.4826;
    private final long lowThresholdMs;
    private static final int DEVIATION_MULTIPLIER = 3;
    @VisibleForTesting
    static final int MEDIAN_MULTIPLIER = 3;

    public OutlierDetector(long minNumResources, long lowThresholdMs) {
        this.minNumResources = minNumResources;
        this.lowThresholdMs = lowThresholdMs;
    }

    public Map<String, Double> getOutliers(Map<String, Double> stats) {
        if ((long)stats.size() < this.minNumResources) {
            LOG.debug("Skipping statistical outlier detection as we don't have latency data for enough resources. Have {}, need at least {}", (Object)stats.size(), (Object)this.minNumResources);
            return ImmutableMap.of();
        }
        ArrayList<Double> sorted = new ArrayList<Double>(stats.values());
        Collections.sort(sorted);
        Double median = OutlierDetector.computeMedian(sorted);
        Double mad = OutlierDetector.computeMad(sorted);
        Double upperLimitLatency = Math.max((double)this.lowThresholdMs, median * 3.0);
        upperLimitLatency = Math.max(upperLimitLatency, median + 3.0 * mad);
        HashMap<String, Double> slowResources = new HashMap<String, Double>();
        LOG.trace("getOutliers: List={}, MedianLatency={}, MedianAbsoluteDeviation={}, upperLimitLatency={}", new Object[]{sorted, median, mad, upperLimitLatency});
        for (Map.Entry<String, Double> entry : stats.entrySet()) {
            if (!(entry.getValue() > upperLimitLatency)) continue;
            slowResources.put(entry.getKey(), entry.getValue());
        }
        return slowResources;
    }

    public static Double computeMad(List<Double> sortedValues) {
        if (sortedValues.size() == 0) {
            throw new IllegalArgumentException("Cannot compute the Median Absolute Deviation of an empty list.");
        }
        Double median = OutlierDetector.computeMedian(sortedValues);
        ArrayList<Double> deviations = new ArrayList<Double>(sortedValues);
        for (int i = 0; i < sortedValues.size(); ++i) {
            deviations.set(i, Math.abs(sortedValues.get(i) - median));
        }
        Collections.sort(deviations);
        return OutlierDetector.computeMedian(deviations) * 1.4826;
    }

    public static Double computeMedian(List<Double> sortedValues) {
        if (sortedValues.size() == 0) {
            throw new IllegalArgumentException("Cannot compute the median of an empty list.");
        }
        Double median = sortedValues.get(sortedValues.size() / 2);
        if (sortedValues.size() % 2 == 0) {
            median = median + sortedValues.get(sortedValues.size() / 2 - 1);
            median = median / 2.0;
        }
        return median;
    }
}

