/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.fs.permission.AclEntry;
import shaded.org.apache.hadoop.hdfs.server.namenode.INode;
import shaded.org.apache.hadoop.hdfs.util.ReferenceCountMap;

@InterfaceAudience.Private
public class AclFeature
implements INode.Feature,
ReferenceCountMap.ReferenceCounter {
    public static final ImmutableList<AclEntry> EMPTY_ENTRY_LIST = ImmutableList.of();
    private int refCount = 0;
    private final int[] entries;

    public AclFeature(int[] entries) {
        this.entries = entries;
    }

    int getEntriesSize() {
        return this.entries.length;
    }

    int getEntryAt(int pos) {
        Preconditions.checkPositionIndex((int)pos, (int)this.entries.length, (String)"Invalid position for AclEntry");
        return this.entries[pos];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.entries, ((AclFeature)o).entries);
    }

    public int hashCode() {
        return Arrays.hashCode(this.entries);
    }

    @Override
    public int getRefCount() {
        return this.refCount;
    }

    @Override
    public int incrementAndGetRefCount() {
        return ++this.refCount;
    }

    @Override
    public int decrementAndGetRefCount() {
        return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
    }
}

