/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.permission.FsAction;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import shaded.org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import shaded.org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import shaded.org.apache.hadoop.security.AccessControlException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContentSummaryComputationContext {
    private FSDirectory dir = null;
    private FSNamesystem fsn = null;
    private BlockStoragePolicySuite bsps = null;
    private ContentCounts counts = null;
    private ContentCounts snapshotCounts = null;
    private long nextCountLimit = 0L;
    private long limitPerRun = 0L;
    private long yieldCount = 0L;
    private long sleepMilliSec = 0L;
    private int sleepNanoSec = 0;
    private FSPermissionChecker pc;

    public ContentSummaryComputationContext(FSDirectory dir, FSNamesystem fsn, long limitPerRun, long sleepMicroSec) {
        this(dir, fsn, limitPerRun, sleepMicroSec, null);
    }

    public ContentSummaryComputationContext(FSDirectory dir, FSNamesystem fsn, long limitPerRun, long sleepMicroSec, FSPermissionChecker pc) {
        this.dir = dir;
        this.fsn = fsn;
        this.limitPerRun = limitPerRun;
        this.nextCountLimit = limitPerRun;
        this.counts = new ContentCounts.Builder().build();
        this.snapshotCounts = new ContentCounts.Builder().build();
        this.sleepMilliSec = sleepMicroSec / 1000L;
        this.sleepNanoSec = (int)(sleepMicroSec % 1000L * 1000L);
        this.pc = pc;
    }

    public ContentSummaryComputationContext(BlockStoragePolicySuite bsps) {
        this(null, null, 0L, 1000L);
        this.bsps = bsps;
    }

    public long getYieldCount() {
        return this.yieldCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean yield() {
        if (this.limitPerRun <= 0L || this.dir == null || this.fsn == null) {
            return false;
        }
        long currentCount = this.counts.getFileCount() + this.counts.getSymlinkCount() + this.counts.getDirectoryCount() + this.counts.getSnapshotableDirectoryCount();
        if (currentCount <= this.nextCountLimit) {
            return false;
        }
        this.nextCountLimit = currentCount + this.limitPerRun;
        boolean hadDirReadLock = this.dir.hasReadLock();
        boolean hadDirWriteLock = this.dir.hasWriteLock();
        boolean hadFsnReadLock = this.fsn.hasReadLock();
        boolean hadFsnWriteLock = this.fsn.hasWriteLock();
        if (!hadDirReadLock || !hadFsnReadLock || hadDirWriteLock || hadFsnWriteLock || this.dir.getReadHoldCount() != 1 || this.fsn.getReadHoldCount() != 1) {
            return false;
        }
        this.dir.readUnlock();
        this.fsn.readUnlock("contentSummary");
        try {
            Thread.sleep(this.sleepMilliSec, this.sleepNanoSec);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.fsn.readLock();
            this.dir.readLock();
        }
        ++this.yieldCount;
        return true;
    }

    public ContentCounts getCounts() {
        return this.counts;
    }

    public ContentCounts getSnapshotCounts() {
        return this.snapshotCounts;
    }

    public BlockStoragePolicySuite getBlockStoragePolicySuite() {
        Preconditions.checkState((this.bsps != null || this.fsn != null ? 1 : 0) != 0, (Object)"BlockStoragePolicySuite must be either initialized or available via FSNameSystem");
        return this.bsps != null ? this.bsps : this.fsn.getBlockManager().getStoragePolicySuite();
    }

    void checkPermission(INodeDirectory inode, int snapshotId, FsAction access) throws AccessControlException {
        if (this.dir != null && this.dir.isPermissionEnabled() && this.pc != null && !this.pc.isSuperUser()) {
            this.pc.checkPermission(inode, snapshotId, access);
        }
    }
}

