/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import shaded.org.apache.hadoop.fs.permission.FsPermission;
import shaded.org.apache.hadoop.fs.permission.PermissionStatus;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import shaded.org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import shaded.org.apache.hadoop.hdfs.server.namenode.INode;
import shaded.org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import shaded.org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import shaded.org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import shaded.org.apache.hadoop.util.GSet;
import shaded.org.apache.hadoop.util.LightWeightGSet;

public class INodeMap {
    private final GSet<INode, INodeWithAdditionalFields> map;

    static INodeMap newInstance(INodeDirectory rootDir) {
        int capacity = LightWeightGSet.computeCapacity(1.0, "INodeMap");
        LightWeightGSet<INode, INodeWithAdditionalFields> map = new LightWeightGSet<INode, INodeWithAdditionalFields>(capacity);
        map.put(rootDir);
        return new INodeMap(map);
    }

    public Iterator<INodeWithAdditionalFields> getMapIterator() {
        return this.map.iterator();
    }

    private INodeMap(GSet<INode, INodeWithAdditionalFields> map) {
        Preconditions.checkArgument((map != null ? 1 : 0) != 0);
        this.map = map;
    }

    public final void put(INode inode) {
        if (inode instanceof INodeWithAdditionalFields) {
            this.map.put((INodeWithAdditionalFields)inode);
        }
    }

    public final void remove(INode inode) {
        this.map.remove(inode);
    }

    public int size() {
        return this.map.size();
    }

    public INode get(long id) {
        INodeWithAdditionalFields inode = new INodeWithAdditionalFields(id, null, new PermissionStatus("", "", new FsPermission(0)), 0L, 0L){

            @Override
            void recordModification(int latestSnapshotId) {
            }

            @Override
            public void destroyAndCollectBlocks(INode.ReclaimContext reclaimContext) {
            }

            @Override
            public QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, boolean useCache, int lastSnapshotId) {
                return null;
            }

            @Override
            public ContentSummaryComputationContext computeContentSummary(int snapshotId, ContentSummaryComputationContext summary) {
                return null;
            }

            @Override
            public void cleanSubtree(INode.ReclaimContext reclaimContext, int snapshotId, int priorSnapshotId) {
            }

            @Override
            public byte getStoragePolicyID() {
                return 0;
            }

            @Override
            public byte getLocalStoragePolicyID() {
                return 0;
            }
        };
        return this.map.get(inode);
    }

    public void clear() {
        this.map.clear();
    }
}

