/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.hdfs.DFSUtil;
import shaded.org.apache.hadoop.hdfs.HAUtil;
import shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;

public class RemoteNameNodeInfo {
    private final Configuration conf;
    private final String nnId;
    private InetSocketAddress ipcAddress;
    private final URL httpAddress;

    public static List<RemoteNameNodeInfo> getRemoteNameNodes(Configuration conf) throws IOException {
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        return RemoteNameNodeInfo.getRemoteNameNodes(conf, nsId);
    }

    public static List<RemoteNameNodeInfo> getRemoteNameNodes(Configuration conf, String nsId) throws IOException {
        if (nsId == null) {
            return Collections.emptyList();
        }
        List<Configuration> otherNodes = HAUtil.getConfForOtherNodes(conf);
        ArrayList<RemoteNameNodeInfo> nns = new ArrayList<RemoteNameNodeInfo>();
        for (Configuration otherNode : otherNodes) {
            String otherNNId = HAUtil.getNameNodeId(otherNode, nsId);
            InetSocketAddress otherIpcAddr = NameNode.getServiceAddress(otherNode, true);
            String scheme = DFSUtil.getHttpClientScheme(conf);
            URL otherHttpAddr = DFSUtil.getInfoServerWithDefaultHost(otherIpcAddr.getHostName(), otherNode, scheme).toURL();
            nns.add(new RemoteNameNodeInfo(otherNode, otherNNId, otherIpcAddr, otherHttpAddr));
        }
        return nns;
    }

    private RemoteNameNodeInfo(Configuration conf, String nnId, InetSocketAddress ipcAddress, URL httpAddress) {
        this.conf = conf;
        this.nnId = nnId;
        this.ipcAddress = ipcAddress;
        this.httpAddress = httpAddress;
    }

    public InetSocketAddress getIpcAddress() {
        return this.ipcAddress;
    }

    public String getNameNodeID() {
        return this.nnId;
    }

    public URL getHttpAddress() {
        return this.httpAddress;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void setIpcAddress(InetSocketAddress ipc) {
        this.ipcAddress = ipc;
    }

    public String toString() {
        return "RemoteNameNodeInfo [nnId=" + this.nnId + ", ipcAddress=" + this.ipcAddress + ", httpAddress=" + this.httpAddress + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteNameNodeInfo that = (RemoteNameNodeInfo)o;
        if (!this.nnId.equals(that.nnId)) {
            return false;
        }
        if (!this.ipcAddress.equals(that.ipcAddress)) {
            return false;
        }
        String httpString = this.httpAddress.toString();
        String thatHttpString = that.httpAddress.toString();
        return httpString.equals(thatHttpString);
    }

    public int hashCode() {
        int result = this.nnId.hashCode();
        result = 31 * result + this.ipcAddress.hashCode();
        result = 31 * result + this.httpAddress.toString().hashCode();
        return result;
    }
}

