/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.ha.ServiceFailedException;
import shaded.org.apache.hadoop.hdfs.DFSUtil;
import shaded.org.apache.hadoop.hdfs.HAUtil;
import shaded.org.apache.hadoop.hdfs.server.namenode.CheckpointConf;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSImage;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import shaded.org.apache.hadoop.hdfs.server.namenode.NNStorage;
import shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import shaded.org.apache.hadoop.hdfs.server.namenode.SaveNamespaceCancelledException;
import shaded.org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import shaded.org.apache.hadoop.hdfs.util.Canceler;
import shaded.org.apache.hadoop.io.MultipleIOException;
import shaded.org.apache.hadoop.security.SecurityUtil;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class StandbyCheckpointer {
    private static final Log LOG = LogFactory.getLog(StandbyCheckpointer.class);
    private static final long PREVENT_AFTER_CANCEL_MS = 120000L;
    private final CheckpointConf checkpointConf;
    private final Configuration conf;
    private final FSNamesystem namesystem;
    private long lastCheckpointTime;
    private final CheckpointerThread thread;
    private final ThreadFactory uploadThreadFactory;
    private List<URL> activeNNAddresses;
    private URL myNNAddress;
    private final Object cancelLock = new Object();
    private Canceler canceler;
    private static int canceledCount = 0;
    private final HashMap<String, CheckpointReceiverEntry> checkpointReceivers;

    public StandbyCheckpointer(Configuration conf, FSNamesystem ns) throws IOException {
        this.namesystem = ns;
        this.conf = conf;
        this.checkpointConf = new CheckpointConf(conf);
        this.thread = new CheckpointerThread();
        this.uploadThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TransferFsImageUpload-%d").build();
        this.setNameNodeAddresses(conf);
        this.checkpointReceivers = new HashMap();
        for (URL address : this.activeNNAddresses) {
            this.checkpointReceivers.put(address.toString(), new CheckpointReceiverEntry());
        }
    }

    private void setNameNodeAddresses(Configuration conf) throws IOException {
        this.myNNAddress = this.getHttpAddress(conf);
        List<Configuration> confForActive = HAUtil.getConfForOtherNodes(conf);
        this.activeNNAddresses = new ArrayList<URL>(confForActive.size());
        for (Configuration activeConf : confForActive) {
            URL activeNNAddress = this.getHttpAddress(activeConf);
            Preconditions.checkArgument((boolean)StandbyCheckpointer.checkAddress(activeNNAddress), (String)"Bad address for active NN: %s", (Object[])new Object[]{activeNNAddress});
            this.activeNNAddresses.add(activeNNAddress);
        }
        Preconditions.checkArgument((boolean)StandbyCheckpointer.checkAddress(this.myNNAddress), (String)"Bad address for standby NN: %s", (Object[])new Object[]{this.myNNAddress});
    }

    private URL getHttpAddress(Configuration conf) throws IOException {
        String scheme = DFSUtil.getHttpClientScheme(conf);
        String defaultHost = NameNode.getServiceAddress(conf, true).getHostName();
        URI addr = DFSUtil.getInfoServerWithDefaultHost(defaultHost, conf, scheme);
        return addr.toURL();
    }

    private static boolean checkAddress(URL addr) {
        return addr.getPort() != 0;
    }

    public void start() {
        LOG.info((Object)("Starting standby checkpoint thread...\nCheckpointing active NN to possible NNs: " + this.activeNNAddresses + "\n" + "Serving checkpoints at " + this.myNNAddress));
        this.thread.start();
    }

    public void stop() throws IOException {
        this.cancelAndPreventCheckpoints("Stopping checkpointer");
        this.thread.setShouldRun(false);
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Edit log tailer thread exited with an exception");
            throw new IOException(e);
        }
    }

    public void triggerRollbackCheckpoint() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckpoint() throws InterruptedException, IOException {
        long txid;
        NNStorage.NameNodeFile imageType;
        assert (this.canceler != null);
        this.namesystem.cpLockInterruptibly();
        try {
            assert (this.namesystem.getEditLog().isOpenForRead()) : "Standby Checkpointer should only attempt a checkpoint when NN is in standby mode, but the edit logs are in an unexpected state";
            FSImage img = this.namesystem.getFSImage();
            long prevCheckpointTxId = img.getStorage().getMostRecentCheckpointTxId();
            long thisCheckpointTxId = img.getCorrectLastAppliedOrWrittenTxId();
            assert (thisCheckpointTxId >= prevCheckpointTxId);
            if (thisCheckpointTxId == prevCheckpointTxId) {
                LOG.info((Object)("A checkpoint was triggered but the Standby Node has not received any transactions since the last checkpoint at txid " + thisCheckpointTxId + ". Skipping..."));
                return;
            }
            imageType = this.namesystem.isRollingUpgrade() && !this.namesystem.getFSImage().hasRollbackFSImage() ? NNStorage.NameNodeFile.IMAGE_ROLLBACK : NNStorage.NameNodeFile.IMAGE;
            img.saveNamespace(this.namesystem, imageType, this.canceler);
            txid = img.getStorage().getMostRecentCheckpointTxId();
            assert (txid == thisCheckpointTxId) : "expected to save checkpoint at txid=" + thisCheckpointTxId + " but instead saved at txid=" + txid;
            String outputDir = this.checkpointConf.getLegacyOivImageDir();
            if (outputDir != null && !outputDir.isEmpty()) {
                try {
                    img.saveLegacyOIVImage(this.namesystem, outputDir, this.canceler);
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Exception encountered while saving legacy OIV image; continuing with other checkpointing steps", (Throwable)ioe);
                }
            }
        }
        finally {
            this.namesystem.cpUnlock();
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, this.activeNNAddresses.size(), 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.activeNNAddresses.size()), this.uploadThreadFactory);
        HashMap<String, Future<TransferFsImage.TransferResult>> uploads = new HashMap<String, Future<TransferFsImage.TransferResult>>();
        for (final URL activeNNAddress : this.activeNNAddresses) {
            String addressString = activeNNAddress.toString();
            assert (this.checkpointReceivers.containsKey(addressString));
            CheckpointReceiverEntry receiverEntry = this.checkpointReceivers.get(addressString);
            long secsSinceLastUpload = TimeUnit.MILLISECONDS.toSeconds(Time.monotonicNow() - receiverEntry.getLastUploadTime());
            boolean shouldUpload = receiverEntry.isPrimary() || (double)secsSinceLastUpload >= this.checkpointConf.getQuietPeriod();
            if (!shouldUpload) continue;
            Future<TransferFsImage.TransferResult> upload = executor.submit(new Callable<TransferFsImage.TransferResult>(){

                @Override
                public TransferFsImage.TransferResult call() throws IOException {
                    return TransferFsImage.uploadImageFromStorage(activeNNAddress, StandbyCheckpointer.this.conf, StandbyCheckpointer.this.namesystem.getFSImage().getStorage(), imageType, txid, StandbyCheckpointer.this.canceler);
                }
            });
            uploads.put(addressString, upload);
        }
        InterruptedException ie = null;
        ArrayList ioes = Lists.newArrayList();
        for (Map.Entry entry : uploads.entrySet()) {
            String url = (String)entry.getKey();
            Future upload = (Future)entry.getValue();
            try {
                CheckpointReceiverEntry receiverEntry = this.checkpointReceivers.get(url);
                TransferFsImage.TransferResult uploadResult = (TransferFsImage.TransferResult)((Object)upload.get());
                if (uploadResult == TransferFsImage.TransferResult.SUCCESS) {
                    receiverEntry.setLastUploadTime(Time.monotonicNow());
                    receiverEntry.setIsPrimary(true);
                    continue;
                }
                LOG.info((Object)("Image upload rejected by the other NameNode: " + (Object)((Object)uploadResult)));
                receiverEntry.setIsPrimary(false);
            }
            catch (ExecutionException e) {
                ioes.add(new IOException("Exception during image upload", e));
            }
            catch (InterruptedException e) {
                ie = e;
                break;
            }
        }
        if (ie != null) {
            for (Map.Entry entry : uploads.entrySet()) {
                Future upload = (Future)entry.getValue();
                upload.cancel(true);
            }
            executor.shutdownNow();
            executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
            throw ie;
        }
        if (!ioes.isEmpty()) {
            throw MultipleIOException.createIOException(ioes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAndPreventCheckpoints(String msg) throws ServiceFailedException {
        Object object = this.cancelLock;
        synchronized (object) {
            this.thread.preventCheckpointsFor(120000L);
            if (this.canceler != null) {
                this.canceler.cancel(msg);
            }
        }
    }

    @VisibleForTesting
    static int getCanceledCount() {
        return canceledCount;
    }

    private long countUncheckpointedTxns() {
        FSImage img = this.namesystem.getFSImage();
        return img.getCorrectLastAppliedOrWrittenTxId() - img.getStorage().getMostRecentCheckpointTxId();
    }

    @VisibleForTesting
    List<URL> getActiveNNAddresses() {
        return this.activeNNAddresses;
    }

    private class CheckpointerThread
    extends Thread {
        private volatile boolean shouldRun;
        private volatile long preventCheckpointsUntil;

        private CheckpointerThread() {
            super("Standby State Checkpointer");
            this.shouldRun = true;
            this.preventCheckpointsUntil = 0L;
        }

        private void setShouldRun(boolean shouldRun) {
            this.shouldRun = shouldRun;
        }

        @Override
        public void run() {
            SecurityUtil.doAsLoginUserOrFatal(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    CheckpointerThread.this.doWork();
                    return null;
                }
            });
        }

        private void preventCheckpointsFor(long delayMs) {
            this.preventCheckpointsUntil = Time.monotonicNow() + delayMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWork() {
            long checkPeriod = 1000L * StandbyCheckpointer.this.checkpointConf.getCheckPeriod();
            StandbyCheckpointer.this.lastCheckpointTime = Time.monotonicNow();
            while (this.shouldRun) {
                boolean needRollbackCheckpoint = StandbyCheckpointer.this.namesystem.isNeedRollbackFsImage();
                if (!needRollbackCheckpoint) {
                    try {
                        Thread.sleep(checkPeriod);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.shouldRun) break;
                }
                try {
                    if (UserGroupInformation.isSecurityEnabled()) {
                        UserGroupInformation.getCurrentUser().checkTGTAndReloginFromKeytab();
                    }
                    long now = Time.monotonicNow();
                    long uncheckpointed = StandbyCheckpointer.this.countUncheckpointedTxns();
                    long secsSinceLast = (now - StandbyCheckpointer.this.lastCheckpointTime) / 1000L;
                    boolean needCheckpoint = needRollbackCheckpoint;
                    if (needCheckpoint) {
                        LOG.info((Object)"Triggering a rollback fsimage for rolling upgrade.");
                    } else if (uncheckpointed >= StandbyCheckpointer.this.checkpointConf.getTxnCount()) {
                        LOG.info((Object)("Triggering checkpoint because there have been " + uncheckpointed + " txns since the last checkpoint, which " + "exceeds the configured threshold " + StandbyCheckpointer.this.checkpointConf.getTxnCount()));
                        needCheckpoint = true;
                    } else if (secsSinceLast >= StandbyCheckpointer.this.checkpointConf.getPeriod()) {
                        LOG.info((Object)("Triggering checkpoint because it has been " + secsSinceLast + " seconds since the last checkpoint, which " + "exceeds the configured interval " + StandbyCheckpointer.this.checkpointConf.getPeriod()));
                        needCheckpoint = true;
                    }
                    if (!needCheckpoint) continue;
                    Object object = StandbyCheckpointer.this.cancelLock;
                    synchronized (object) {
                        block44: {
                            if (now >= this.preventCheckpointsUntil) break block44;
                            LOG.info((Object)"But skipping this checkpoint since we are about to failover!");
                            canceledCount++;
                            continue;
                        }
                        assert (StandbyCheckpointer.this.canceler == null);
                        StandbyCheckpointer.this.canceler = new Canceler();
                    }
                    StandbyCheckpointer.this.doCheckpoint();
                    if (needRollbackCheckpoint && StandbyCheckpointer.this.namesystem.getFSImage().hasRollbackFSImage()) {
                        StandbyCheckpointer.this.namesystem.setCreatedRollbackImages(true);
                        StandbyCheckpointer.this.namesystem.setNeedRollbackFsImage(false);
                    }
                    StandbyCheckpointer.this.lastCheckpointTime = now;
                }
                catch (SaveNamespaceCancelledException ce) {
                    LOG.info((Object)("Checkpoint was cancelled: " + ce.getMessage()));
                    canceledCount++;
                }
                catch (InterruptedException ie) {
                    LOG.info((Object)"Interrupted during checkpointing", (Throwable)ie);
                }
                catch (Throwable t) {
                    LOG.error((Object)"Exception in doCheckpoint", t);
                }
                finally {
                    Object ce = StandbyCheckpointer.this.cancelLock;
                    synchronized (ce) {
                        StandbyCheckpointer.this.canceler = null;
                    }
                }
            }
        }
    }

    private static final class CheckpointReceiverEntry {
        private long lastUploadTime = 0L;
        private boolean isPrimary = true;

        CheckpointReceiverEntry() {
        }

        void setLastUploadTime(long lastUploadTime) {
            this.lastUploadTime = lastUploadTime;
        }

        void setIsPrimary(boolean isPrimaryFor) {
            this.isPrimary = isPrimaryFor;
        }

        long getLastUploadTime() {
            return this.lastUploadTime;
        }

        boolean isPrimary() {
            return this.isPrimary;
        }
    }
}

