/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.ha.HAServiceProtocol;
import shaded.org.apache.hadoop.ha.ServiceFailedException;
import shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import shaded.org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import shaded.org.apache.hadoop.hdfs.server.namenode.ha.HAState;
import shaded.org.apache.hadoop.ipc.ObserverRetryOnActiveException;
import shaded.org.apache.hadoop.ipc.StandbyException;

@InterfaceAudience.Private
public class StandbyState
extends HAState {
    private final boolean isObserver;

    public StandbyState() {
        this(false);
    }

    public StandbyState(boolean isObserver) {
        super(isObserver ? HAServiceProtocol.HAServiceState.OBSERVER : HAServiceProtocol.HAServiceState.STANDBY);
        this.isObserver = isObserver;
    }

    @Override
    public void setState(HAContext context, HAState s) throws ServiceFailedException {
        if (s == NameNode.ACTIVE_STATE || !this.isObserver && s == NameNode.OBSERVER_STATE || this.isObserver && s == NameNode.STANDBY_STATE) {
            this.setStateInternal(context, s);
            return;
        }
        super.setState(context, s);
    }

    @Override
    public void enterState(HAContext context) throws ServiceFailedException {
        try {
            context.startStandbyServices();
        }
        catch (IOException e) {
            throw new ServiceFailedException("Failed to start standby services", e);
        }
    }

    @Override
    public void prepareToExitState(HAContext context) throws ServiceFailedException {
        context.prepareToStopStandbyServices();
    }

    @Override
    public void exitState(HAContext context) throws ServiceFailedException {
        try {
            context.stopStandbyServices();
        }
        catch (IOException e) {
            throw new ServiceFailedException("Failed to stop standby services", e);
        }
    }

    @Override
    public void checkOperation(HAContext context, NameNode.OperationCategory op) throws StandbyException {
        if (op == NameNode.OperationCategory.UNCHECKED || op == NameNode.OperationCategory.READ && context.allowStaleReads()) {
            return;
        }
        String faq = ". Visit https://s.apache.org/sbnn-error";
        String msg = "Operation category " + (Object)((Object)op) + " is not supported in state " + context.getState() + faq;
        if (op == NameNode.OperationCategory.WRITE && this.isObserver) {
            throw new ObserverRetryOnActiveException(msg);
        }
        throw new StandbyException(msg);
    }

    @Override
    public boolean shouldPopulateReplQueues() {
        return false;
    }

    @Override
    public String toString() {
        return this.isObserver ? "observer" : "standby";
    }
}

