/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.AbstractTracking;
import shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.PhaseTracking;
import shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.Status;
import shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.StepTracking;
import shaded.org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class StartupProgressView {
    private final Map<Phase, PhaseTracking> phases = new HashMap<Phase, PhaseTracking>();

    public long getCount(Phase phase) {
        long sum = 0L;
        for (Step step : this.getSteps(phase)) {
            sum += this.getCount(phase, step);
        }
        return sum;
    }

    public long getCount(Phase phase, Step step) {
        StepTracking tracking = this.getStepTracking(phase, step);
        return tracking != null ? tracking.count.get() : 0L;
    }

    public long getElapsedTime() {
        return this.getElapsedTime(this.phases.get((Object)Phase.LOADING_FSIMAGE), this.phases.get((Object)Phase.SAFEMODE));
    }

    public long getElapsedTime(Phase phase) {
        return this.getElapsedTime(this.phases.get((Object)phase));
    }

    public long getElapsedTime(Phase phase, Step step) {
        return this.getElapsedTime(this.getStepTracking(phase, step));
    }

    public String getFile(Phase phase) {
        return this.phases.get((Object)((Object)phase)).file;
    }

    public float getPercentComplete() {
        if (this.getStatus(Phase.SAFEMODE) == Status.COMPLETE) {
            return 1.0f;
        }
        float total = 0.0f;
        int numPhases = 0;
        for (Phase phase : this.phases.keySet()) {
            ++numPhases;
            total += this.getPercentComplete(phase);
        }
        return StartupProgressView.getBoundedPercent(total / (float)numPhases);
    }

    public float getPercentComplete(Phase phase) {
        if (this.getStatus(phase) == Status.COMPLETE) {
            return 1.0f;
        }
        long total = this.getTotal(phase);
        long count = 0L;
        for (Step step : this.getSteps(phase)) {
            count += this.getCount(phase, step);
        }
        return total > 0L ? StartupProgressView.getBoundedPercent(1.0f * (float)count / (float)total) : 0.0f;
    }

    public float getPercentComplete(Phase phase, Step step) {
        if (this.getStatus(phase) == Status.COMPLETE) {
            return 1.0f;
        }
        long total = this.getTotal(phase, step);
        long count = this.getCount(phase, step);
        return total > 0L ? StartupProgressView.getBoundedPercent(1.0f * (float)count / (float)total) : 0.0f;
    }

    public Iterable<Phase> getPhases() {
        return EnumSet.allOf(Phase.class);
    }

    public Iterable<Step> getSteps(Phase phase) {
        return new TreeSet<Step>(this.phases.get((Object)((Object)phase)).steps.keySet());
    }

    public long getSize(Phase phase) {
        return this.phases.get((Object)((Object)phase)).size;
    }

    public Status getStatus(Phase phase) {
        PhaseTracking tracking = this.phases.get((Object)phase);
        if (tracking.beginTime == Long.MIN_VALUE) {
            return Status.PENDING;
        }
        if (tracking.endTime == Long.MIN_VALUE) {
            return Status.RUNNING;
        }
        return Status.COMPLETE;
    }

    public long getTotal(Phase phase) {
        long sum = 0L;
        for (StepTracking tracking : this.phases.get((Object)((Object)phase)).steps.values()) {
            if (tracking.total == Long.MIN_VALUE) continue;
            sum += tracking.total;
        }
        return sum;
    }

    public long getTotal(Phase phase, Step step) {
        StepTracking tracking = this.getStepTracking(phase, step);
        return tracking != null && tracking.total != Long.MIN_VALUE ? tracking.total : 0L;
    }

    StartupProgressView(StartupProgress prog) {
        for (Map.Entry<Phase, PhaseTracking> entry : prog.phases.entrySet()) {
            this.phases.put(entry.getKey(), entry.getValue().clone());
        }
    }

    private long getElapsedTime(AbstractTracking tracking) {
        return this.getElapsedTime(tracking, tracking);
    }

    private long getElapsedTime(AbstractTracking beginTracking, AbstractTracking endTracking) {
        long elapsed = beginTracking != null && beginTracking.beginTime != Long.MIN_VALUE && endTracking != null && endTracking.endTime != Long.MIN_VALUE ? endTracking.endTime - beginTracking.beginTime : (beginTracking != null && beginTracking.beginTime != Long.MIN_VALUE ? Time.monotonicNow() - beginTracking.beginTime : 0L);
        return Math.max(0L, elapsed);
    }

    private StepTracking getStepTracking(Phase phase, Step step) {
        PhaseTracking phaseTracking = this.phases.get((Object)phase);
        ConcurrentMap<Step, StepTracking> steps = phaseTracking != null ? phaseTracking.steps : null;
        return steps != null ? (StepTracking)steps.get(step) : null;
    }

    private static float getBoundedPercent(float percent) {
        return Math.max(0.0f, Math.min(1.0f, percent));
    }
}

