/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.protocol;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import shaded.org.apache.hadoop.hdfs.server.common.Storage;
import shaded.org.apache.hadoop.hdfs.server.common.StorageInfo;
import shaded.org.apache.hadoop.hdfs.server.protocol.NodeRegistration;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NamenodeRegistration
extends StorageInfo
implements NodeRegistration {
    final String rpcAddress;
    final String httpAddress;
    final HdfsServerConstants.NamenodeRole role;

    public NamenodeRegistration(String address, String httpAddress, StorageInfo storageInfo, HdfsServerConstants.NamenodeRole role) {
        super(storageInfo);
        this.rpcAddress = address;
        this.httpAddress = httpAddress;
        this.role = role;
    }

    @Override
    public String getAddress() {
        return this.rpcAddress;
    }

    public String getHttpAddress() {
        return this.httpAddress;
    }

    @Override
    public String getRegistrationID() {
        return Storage.getRegistrationID(this);
    }

    @Override
    public int getVersion() {
        return super.getLayoutVersion();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.rpcAddress + ", role=" + (Object)((Object)this.getRole()) + ")";
    }

    public HdfsServerConstants.NamenodeRole getRole() {
        return this.role;
    }

    public boolean isRole(HdfsServerConstants.NamenodeRole that) {
        return this.role.equals((Object)that);
    }
}

