/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.File;
import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class BinaryEditsVisitor
implements OfflineEditsVisitor {
    private final EditLogFileOutputStream elfos;

    public BinaryEditsVisitor(String outputName) throws IOException {
        this.elfos = new EditLogFileOutputStream(new Configuration(), new File(outputName), 0);
        this.elfos.create(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
    }

    @Override
    public void start(int version) throws IOException {
    }

    @Override
    public void close(Throwable error) throws IOException {
        this.elfos.setReadyToFlush();
        this.elfos.flushAndSync(true);
        this.elfos.close();
    }

    @Override
    public void visitOp(FSEditLogOp op) throws IOException {
        this.elfos.write(op);
    }
}

