/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.BinaryEditsVisitor;
import shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.StatisticsEditsVisitor;
import shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.TeeOutputStream;
import shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.XmlEditsVisitor;
import shaded.org.apache.hadoop.io.IOUtils;
import shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OfflineEditsVisitorFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OfflineEditsVisitor getEditsVisitor(String filename, String processor, boolean printToScreen) throws IOException {
        if (StringUtils.equalsIgnoreCase("binary", processor)) {
            return new BinaryEditsVisitor(filename);
        }
        FileOutputStream fout = new FileOutputStream(filename);
        OutputStream out = null;
        try {
            OfflineEditsVisitor vis;
            if (!printToScreen) {
                out = fout;
            } else {
                OutputStream[] outs = new OutputStream[]{fout, System.out};
                out = new TeeOutputStream(outs);
            }
            if (StringUtils.equalsIgnoreCase("xml", processor)) {
                vis = new XmlEditsVisitor(out);
            } else if (StringUtils.equalsIgnoreCase("stats", processor)) {
                vis = new StatisticsEditsVisitor(out);
            } else {
                throw new IOException("Unknown proccesor " + processor + " (valid processors: xml, binary, stats)");
            }
            fout = null;
            out = null;
            OfflineEditsVisitor offlineEditsVisitor = vis;
            return offlineEditsVisitor;
        }
        finally {
            IOUtils.closeStream(fout);
            IOUtils.closeStream(out);
        }
    }
}

