/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.DataInputStream;
import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageLoaderCurrent;
import shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;

interface ImageLoader {
    public void loadImage(DataInputStream var1, ImageVisitor var2, boolean var3) throws IOException;

    public boolean canLoadVersion(int var1);

    @InterfaceAudience.Private
    public static class LoaderFactory {
        public static ImageLoader getLoader(int version) {
            ImageLoader[] loaders;
            for (ImageLoader l : loaders = new ImageLoader[]{new ImageLoaderCurrent()}) {
                if (!l.canLoadVersion(version)) continue;
                return l;
            }
            return null;
        }
    }
}

