/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.fs.permission.PermissionStatus;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSImageFormatPBINode;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import shaded.org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import shaded.org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.IgnoreSnapshotException;
import shaded.org.apache.hadoop.io.IOUtils;
import shaded.org.apache.hadoop.util.LimitInputStream;
import shaded.org.apache.hadoop.util.Time;

abstract class PBImageTextWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PBImageTextWriter.class);
    private SerialNumberManager.StringTable stringTable;
    private PrintStream out;
    private MetadataMap metadataMap = null;

    PBImageTextWriter(PrintStream out, String tempPath) throws IOException {
        this.out = out;
        this.metadataMap = tempPath.isEmpty() ? new InMemoryMetadataDB() : new LevelDBMetadataMap(tempPath);
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        IOUtils.cleanup(null, this.metadataMap);
    }

    protected abstract String getEntry(String var1, FsImageProto.INodeSection.INode var2);

    protected abstract String getHeader();

    public void visit(RandomAccessFile file) throws IOException {
        Configuration conf = new Configuration();
        if (!FSImageUtil.checkFileFormat(file)) {
            throw new IOException("Unrecognized FSImage");
        }
        FsImageProto.FileSummary summary = FSImageUtil.loadSummary(file);
        try (FileInputStream fin = new FileInputStream(file.getFD());){
            ArrayList sections = Lists.newArrayList(summary.getSectionsList());
            Collections.sort(sections, new Comparator<FsImageProto.FileSummary.Section>(){

                @Override
                public int compare(FsImageProto.FileSummary.Section s1, FsImageProto.FileSummary.Section s2) {
                    FSImageFormatProtobuf.SectionName n1 = FSImageFormatProtobuf.SectionName.fromString(s1.getName());
                    FSImageFormatProtobuf.SectionName n2 = FSImageFormatProtobuf.SectionName.fromString(s2.getName());
                    if (n1 == null) {
                        return n2 == null ? 0 : -1;
                    }
                    if (n2 == null) {
                        return -1;
                    }
                    return n1.ordinal() - n2.ordinal();
                }
            });
            ImmutableList<Long> refIdList = null;
            for (FsImageProto.FileSummary.Section section : sections) {
                fin.getChannel().position(section.getOffset());
                InputStream is = FSImageUtil.wrapInputStreamForCompression(conf, summary.getCodec(), new BufferedInputStream(new LimitInputStream(fin, section.getLength())));
                switch (FSImageFormatProtobuf.SectionName.fromString(section.getName())) {
                    case STRING_TABLE: {
                        LOG.info("Loading string table");
                        this.stringTable = FSImageLoader.loadStringTable(is);
                        break;
                    }
                    case INODE_REFERENCE: {
                        LOG.info("Loading inode references");
                        refIdList = FSImageLoader.loadINodeReferenceSection(is);
                        break;
                    }
                }
            }
            this.loadDirectories(fin, sections, summary, conf);
            this.loadINodeDirSection(fin, sections, summary, conf, (List<Long>)refIdList);
            this.metadataMap.sync();
            this.output(conf, summary, fin, sections);
        }
    }

    private void output(Configuration conf, FsImageProto.FileSummary summary, FileInputStream fin, ArrayList<FsImageProto.FileSummary.Section> sections) throws IOException {
        long startTime = Time.monotonicNow();
        this.out.println(this.getHeader());
        for (FsImageProto.FileSummary.Section section : sections) {
            if (FSImageFormatProtobuf.SectionName.fromString(section.getName()) != FSImageFormatProtobuf.SectionName.INODE) continue;
            fin.getChannel().position(section.getOffset());
            InputStream is = FSImageUtil.wrapInputStreamForCompression(conf, summary.getCodec(), new BufferedInputStream(new LimitInputStream(fin, section.getLength())));
            this.outputINodes(is);
        }
        long timeTaken = Time.monotonicNow() - startTime;
        LOG.debug("Time to output inodes: {}ms", (Object)timeTaken);
    }

    protected PermissionStatus getPermission(long perm) {
        return FSImageFormatPBINode.Loader.loadPermission(perm, this.stringTable);
    }

    private void loadDirectories(FileInputStream fin, List<FsImageProto.FileSummary.Section> sections, FsImageProto.FileSummary summary, Configuration conf) throws IOException {
        LOG.info("Loading directories");
        long startTime = Time.monotonicNow();
        for (FsImageProto.FileSummary.Section section : sections) {
            if (FSImageFormatProtobuf.SectionName.fromString(section.getName()) != FSImageFormatProtobuf.SectionName.INODE) continue;
            fin.getChannel().position(section.getOffset());
            InputStream is = FSImageUtil.wrapInputStreamForCompression(conf, summary.getCodec(), new BufferedInputStream(new LimitInputStream(fin, section.getLength())));
            this.loadDirectoriesInINodeSection(is);
        }
        long timeTaken = Time.monotonicNow() - startTime;
        LOG.info("Finished loading directories in {}ms", (Object)timeTaken);
    }

    private void loadINodeDirSection(FileInputStream fin, List<FsImageProto.FileSummary.Section> sections, FsImageProto.FileSummary summary, Configuration conf, List<Long> refIdList) throws IOException {
        LOG.info("Loading INode directory section.");
        long startTime = Time.monotonicNow();
        for (FsImageProto.FileSummary.Section section : sections) {
            if (FSImageFormatProtobuf.SectionName.fromString(section.getName()) != FSImageFormatProtobuf.SectionName.INODE_DIR) continue;
            fin.getChannel().position(section.getOffset());
            InputStream is = FSImageUtil.wrapInputStreamForCompression(conf, summary.getCodec(), new BufferedInputStream(new LimitInputStream(fin, section.getLength())));
            this.buildNamespace(is, refIdList);
        }
        long timeTaken = Time.monotonicNow() - startTime;
        LOG.info("Finished loading INode directory section in {}ms", (Object)timeTaken);
    }

    private void loadDirectoriesInINodeSection(InputStream in) throws IOException {
        FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(in);
        LOG.info("Loading directories in INode section.");
        int numDirs = 0;
        int i = 0;
        while ((long)i < s.getNumInodes()) {
            FsImageProto.INodeSection.INode p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in);
            if (LOG.isDebugEnabled() && i % 10000 == 0) {
                LOG.debug("Scanned {} inodes.", (Object)i);
            }
            if (p.hasDirectory()) {
                this.metadataMap.putDir(p);
                ++numDirs;
            }
            ++i;
        }
        LOG.info("Found {} directories in INode section.", (Object)numDirs);
    }

    private void buildNamespace(InputStream in, List<Long> refIdList) throws IOException {
        FsImageProto.INodeDirectorySection.DirEntry e;
        int count = 0;
        while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom(in)) != null) {
            int i;
            if (LOG.isDebugEnabled() && ++count % 10000 == 0) {
                LOG.debug("Scanned {} directories.", (Object)count);
            }
            long parentId = e.getParent();
            for (i = 0; i < e.getChildrenCount(); ++i) {
                long childId = e.getChildren(i);
                this.metadataMap.putDirChild(parentId, childId);
            }
            for (i = e.getChildrenCount(); i < e.getChildrenCount() + e.getRefChildrenCount(); ++i) {
                int refId = e.getRefChildren(i - e.getChildrenCount());
                this.metadataMap.putDirChild(parentId, refIdList.get(refId));
            }
        }
        LOG.info("Scanned {} INode directories to build namespace.", (Object)count);
    }

    private void outputINodes(InputStream in) throws IOException {
        FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(in);
        LOG.info("Found {} INodes in the INode section", (Object)s.getNumInodes());
        long ignored = 0L;
        long ignoredSnapshots = 0L;
        int i = 0;
        while ((long)i < s.getNumInodes()) {
            block6: {
                FsImageProto.INodeSection.INode p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in);
                try {
                    String parentPath = this.metadataMap.getParentPath(p.getId());
                    this.out.println(this.getEntry(parentPath, p));
                }
                catch (IOException ioe) {
                    ++ignored;
                    if (!(ioe instanceof IgnoreSnapshotException)) {
                        LOG.warn("Exception caught, ignoring node:{}", (Object)p.getId(), (Object)ioe);
                    }
                    ++ignoredSnapshots;
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("Exception caught, ignoring node:{}.", (Object)p.getId(), (Object)ioe);
                }
            }
            if (LOG.isDebugEnabled() && i % 100000 == 0) {
                LOG.debug("Outputted {} INodes.", (Object)i);
            }
            ++i;
        }
        if (ignored > 0L) {
            LOG.warn("Ignored {} nodes, including {} in snapshots. Please turn on debug log for details", (Object)ignored, (Object)ignoredSnapshots);
        }
        LOG.info("Outputted {} INodes.", (Object)s.getNumInodes());
    }

    static void ignoreSnapshotName(long inode) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("No snapshot name found for inode {}", (Object)inode);
        }
        throw new IgnoreSnapshotException();
    }

    private static class LevelDBMetadataMap
    implements MetadataMap {
        private LevelDBStore dirChildMap = null;
        private LevelDBStore dirMap = null;
        private DirPathCache dirPathCache = new DirPathCache();

        LevelDBMetadataMap(String baseDir) throws IOException {
            File dbDir = new File(baseDir);
            if (dbDir.exists()) {
                FileUtils.deleteDirectory((File)dbDir);
            }
            if (!dbDir.mkdirs()) {
                throw new IOException("Failed to mkdir on " + dbDir);
            }
            try {
                this.dirChildMap = new LevelDBStore(new File(dbDir, "dirChildMap"));
                this.dirMap = new LevelDBStore(new File(dbDir, "dirMap"));
            }
            catch (IOException e) {
                LOG.error("Failed to open LevelDBs", (Throwable)e);
                IOUtils.cleanup(null, this);
            }
        }

        @Override
        public void close() throws IOException {
            IOUtils.cleanup(null, this.dirChildMap, this.dirMap);
            this.dirChildMap = null;
            this.dirMap = null;
        }

        private static byte[] toBytes(long value) {
            return ByteBuffer.allocate(8).putLong(value).array();
        }

        private static byte[] toBytes(String value) throws UnsupportedEncodingException {
            return value.getBytes("UTF-8");
        }

        private static long toLong(byte[] bytes) {
            Preconditions.checkArgument((bytes.length == 8 ? 1 : 0) != 0);
            return ByteBuffer.wrap(bytes).getLong();
        }

        private static String toString(byte[] bytes) throws IOException {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void putDirChild(long parentId, long childId) throws IOException {
            this.dirChildMap.put(LevelDBMetadataMap.toBytes(childId), LevelDBMetadataMap.toBytes(parentId));
        }

        @Override
        public void putDir(FsImageProto.INodeSection.INode dir) throws IOException {
            Preconditions.checkArgument((boolean)dir.hasDirectory(), (String)"INode %s (%s) is not a directory.", (Object[])new Object[]{dir.getId(), dir.getName()});
            this.dirMap.put(LevelDBMetadataMap.toBytes(dir.getId()), LevelDBMetadataMap.toBytes(dir.getName().toStringUtf8()));
        }

        @Override
        public String getParentPath(long inode) throws IOException {
            if (inode == 16385L) {
                return "/";
            }
            byte[] bytes = this.dirChildMap.get(LevelDBMetadataMap.toBytes(inode));
            if (bytes == null) {
                PBImageTextWriter.ignoreSnapshotName(inode);
            }
            if (bytes.length != 8) {
                throw new IOException("bytes array length error. Actual length is " + bytes.length);
            }
            long parent = LevelDBMetadataMap.toLong(bytes);
            if (!this.dirPathCache.containsKey(parent)) {
                bytes = this.dirMap.get(LevelDBMetadataMap.toBytes(parent));
                if (parent != 16385L && bytes == null) {
                    PBImageTextWriter.ignoreSnapshotName(parent);
                }
                String parentName = LevelDBMetadataMap.toString(bytes);
                String parentPath = new Path(this.getParentPath(parent), parentName.isEmpty() ? "/" : parentName).toString();
                this.dirPathCache.put(parent, parentPath);
            }
            return (String)this.dirPathCache.get(parent);
        }

        @Override
        public void sync() throws IOException {
            this.dirChildMap.sync();
            this.dirMap.sync();
        }

        private static class DirPathCache
        extends LinkedHashMap<Long, String> {
            private static final int CAPACITY = 16384;

            DirPathCache() {
                super(16384);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, String> entry) {
                return super.size() > 16384;
            }
        }

        private static class LevelDBStore
        implements Closeable {
            private DB db = null;
            private WriteBatch batch = null;
            private int writeCount = 0;
            private static final int BATCH_SIZE = 1024;

            LevelDBStore(File dbPath) throws IOException {
                Options options = new Options();
                options.createIfMissing(true);
                options.errorIfExists(true);
                this.db = JniDBFactory.factory.open(dbPath, options);
                this.batch = this.db.createWriteBatch();
            }

            @Override
            public void close() throws IOException {
                if (this.batch != null) {
                    IOUtils.cleanup(null, new Closeable[]{this.batch});
                    this.batch = null;
                }
                IOUtils.cleanup(null, new Closeable[]{this.db});
                this.db = null;
            }

            public void put(byte[] key, byte[] value) throws IOException {
                this.batch.put(key, value);
                ++this.writeCount;
                if (this.writeCount >= 1024) {
                    this.sync();
                }
            }

            public byte[] get(byte[] key) throws IOException {
                return this.db.get(key);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sync() throws IOException {
                try {
                    this.db.write(this.batch);
                }
                finally {
                    this.batch.close();
                    this.batch = null;
                }
                this.batch = this.db.createWriteBatch();
                this.writeCount = 0;
            }
        }
    }

    private static class InMemoryMetadataDB
    implements MetadataMap {
        private Map<Long, Dir> dirMap = new HashMap<Long, Dir>();
        private Map<Long, Dir> dirChildMap = new HashMap<Long, Dir>();

        InMemoryMetadataDB() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void putDirChild(long parentId, long childId) {
            Dir parent = this.dirMap.get(parentId);
            Dir child = this.dirMap.get(childId);
            if (child != null) {
                child.setParent(parent);
            }
            Preconditions.checkState((!this.dirChildMap.containsKey(childId) ? 1 : 0) != 0);
            this.dirChildMap.put(childId, parent);
        }

        @Override
        public void putDir(FsImageProto.INodeSection.INode p) {
            Preconditions.checkState((!this.dirMap.containsKey(p.getId()) ? 1 : 0) != 0);
            Dir dir = new Dir(p.getId(), p.getName().toStringUtf8());
            this.dirMap.put(p.getId(), dir);
        }

        @Override
        public String getParentPath(long inode) throws IOException {
            if (inode == 16385L) {
                return "";
            }
            Dir parent = this.dirChildMap.get(inode);
            if (parent == null) {
                PBImageTextWriter.ignoreSnapshotName(inode);
            }
            return parent.getPath();
        }

        @Override
        public void sync() {
        }

        private static class Dir {
            private final long inode;
            private Dir parent = null;
            private String name;
            private String path = null;

            Dir(long inode, String name) {
                this.inode = inode;
                this.name = name;
            }

            private void setParent(Dir parent) {
                Preconditions.checkState((this.parent == null ? 1 : 0) != 0);
                this.parent = parent;
            }

            private String getPath() {
                if (this.parent == null) {
                    return "/";
                }
                if (this.path == null) {
                    this.path = new Path(this.parent.getPath(), this.name.isEmpty() ? "/" : this.name).toString();
                    this.name = null;
                }
                return this.path;
            }

            public boolean equals(Object o) {
                return o instanceof Dir && this.inode == ((Dir)o).inode;
            }

            public int hashCode() {
                return Long.valueOf(this.inode).hashCode();
            }
        }
    }

    private static interface MetadataMap
    extends Closeable {
        public void putDirChild(long var1, long var3) throws IOException;

        public void putDir(FsImageProto.INodeSection.INode var1) throws IOException;

        public String getParentPath(long var1) throws IOException;

        public void sync() throws IOException;
    }
}

