/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configurable;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.io.ArrayWritable;
import shaded.org.apache.hadoop.io.BooleanWritable;
import shaded.org.apache.hadoop.io.BytesWritable;
import shaded.org.apache.hadoop.io.DataInputBuffer;
import shaded.org.apache.hadoop.io.DataOutputBuffer;
import shaded.org.apache.hadoop.io.FloatWritable;
import shaded.org.apache.hadoop.io.IntWritable;
import shaded.org.apache.hadoop.io.LongWritable;
import shaded.org.apache.hadoop.io.MD5Hash;
import shaded.org.apache.hadoop.io.MapWritable;
import shaded.org.apache.hadoop.io.NullWritable;
import shaded.org.apache.hadoop.io.ObjectWritable;
import shaded.org.apache.hadoop.io.SortedMapWritable;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.io.TwoDArrayWritable;
import shaded.org.apache.hadoop.io.VIntWritable;
import shaded.org.apache.hadoop.io.VLongWritable;
import shaded.org.apache.hadoop.io.Writable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class AbstractMapWritable
implements Writable,
Configurable {
    private AtomicReference<Configuration> conf;
    @VisibleForTesting
    Map<Class<?>, Byte> classToIdMap = new ConcurrentHashMap();
    @VisibleForTesting
    Map<Byte, Class<?>> idToClassMap = new ConcurrentHashMap();
    private volatile byte newClasses = 0;

    byte getNewClasses() {
        return this.newClasses;
    }

    private synchronized void addToMap(Class<?> clazz, byte id) {
        Class<?> c;
        byte b;
        if (this.classToIdMap.containsKey(clazz) && (b = this.classToIdMap.get(clazz).byteValue()) != id) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " already registered but maps to " + b + " and not " + id);
        }
        if (this.idToClassMap.containsKey(id) && !(c = this.idToClassMap.get(id)).equals(clazz)) {
            throw new IllegalArgumentException("Id " + id + " exists but maps to " + c.getName() + " and not " + clazz.getName());
        }
        this.classToIdMap.put(clazz, id);
        this.idToClassMap.put(id, clazz);
    }

    protected synchronized void addToMap(Class<?> clazz) {
        if (this.classToIdMap.containsKey(clazz)) {
            return;
        }
        if (this.newClasses + 1 > 127) {
            throw new IndexOutOfBoundsException("adding an additional class would exceed the maximum number allowed");
        }
        byte id = this.newClasses = (byte)(this.newClasses + 1);
        this.addToMap(clazz, id);
    }

    protected Class<?> getClass(byte id) {
        return this.idToClassMap.get(id);
    }

    protected byte getId(Class<?> clazz) {
        return this.classToIdMap.containsKey(clazz) ? this.classToIdMap.get(clazz) : (byte)-1;
    }

    protected synchronized void copy(Writable other) {
        if (other != null) {
            try {
                DataOutputBuffer out = new DataOutputBuffer();
                other.write(out);
                DataInputBuffer in = new DataInputBuffer();
                in.reset(out.getData(), out.getLength());
                this.readFields(in);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("map cannot be copied: " + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("source map cannot be null");
        }
    }

    protected AbstractMapWritable() {
        this.conf = new AtomicReference();
        this.addToMap(ArrayWritable.class, (byte)-127);
        this.addToMap(BooleanWritable.class, (byte)-126);
        this.addToMap(BytesWritable.class, (byte)-125);
        this.addToMap(FloatWritable.class, (byte)-124);
        this.addToMap(IntWritable.class, (byte)-123);
        this.addToMap(LongWritable.class, (byte)-122);
        this.addToMap(MapWritable.class, (byte)-121);
        this.addToMap(MD5Hash.class, (byte)-120);
        this.addToMap(NullWritable.class, (byte)-119);
        this.addToMap(ObjectWritable.class, (byte)-118);
        this.addToMap(SortedMapWritable.class, (byte)-117);
        this.addToMap(Text.class, (byte)-116);
        this.addToMap(TwoDArrayWritable.class, (byte)-115);
        this.addToMap(VIntWritable.class, (byte)-114);
        this.addToMap(VLongWritable.class, (byte)-113);
    }

    @Override
    public Configuration getConf() {
        return this.conf.get();
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf.set(conf);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(this.newClasses);
        for (byte i = 1; i <= this.newClasses; i = (byte)(i + 1)) {
            out.writeByte(i);
            out.writeUTF(this.getClass(i).getName());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.newClasses = in.readByte();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (int i = 0; i < this.newClasses; ++i) {
            byte id = in.readByte();
            String className = in.readUTF();
            try {
                this.addToMap(classLoader.loadClass(className), id);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
    }
}

