/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configurable;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.io.compress.CompressionCodec;
import shaded.org.apache.hadoop.io.compress.CompressionInputStream;
import shaded.org.apache.hadoop.io.compress.CompressionOutputStream;
import shaded.org.apache.hadoop.io.compress.Compressor;
import shaded.org.apache.hadoop.io.compress.CompressorStream;
import shaded.org.apache.hadoop.io.compress.Decompressor;
import shaded.org.apache.hadoop.io.compress.DecompressorStream;
import shaded.org.apache.hadoop.io.compress.DirectDecompressionCodec;
import shaded.org.apache.hadoop.io.compress.DirectDecompressor;
import shaded.org.apache.hadoop.io.compress.zlib.ZlibFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DefaultCodec
implements Configurable,
CompressionCodec,
DirectDecompressionCodec {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCodec.class);
    Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return CompressionCodec.Util.createOutputStreamWithCodecPool(this, this.conf, out);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return new CompressorStream(out, compressor, this.conf.getInt("io.file.buffer.size", 4096));
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return ZlibFactory.getZlibCompressorType(this.conf);
    }

    @Override
    public Compressor createCompressor() {
        return ZlibFactory.getZlibCompressor(this.conf);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return CompressionCodec.Util.createInputStreamWithCodecPool(this, this.conf, in);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return new DecompressorStream(in, decompressor, this.conf.getInt("io.file.buffer.size", 4096));
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return ZlibFactory.getZlibDecompressorType(this.conf);
    }

    @Override
    public Decompressor createDecompressor() {
        return ZlibFactory.getZlibDecompressor(this.conf);
    }

    @Override
    public DirectDecompressor createDirectDecompressor() {
        return ZlibFactory.getZlibDirectDecompressor(this.conf);
    }

    @Override
    public String getDefaultExtension() {
        return ".deflate";
    }
}

