/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.io.serializer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.conf.Configured;
import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.io.serializer.Deserializer;
import shaded.org.apache.hadoop.io.serializer.Serialization;
import shaded.org.apache.hadoop.io.serializer.Serializer;
import shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class WritableSerialization
extends Configured
implements Serialization<Writable> {
    @Override
    @InterfaceAudience.Private
    public boolean accept(Class<?> c) {
        return Writable.class.isAssignableFrom(c);
    }

    @Override
    @InterfaceAudience.Private
    public Serializer<Writable> getSerializer(Class<Writable> c) {
        return new WritableSerializer();
    }

    @Override
    @InterfaceAudience.Private
    public Deserializer<Writable> getDeserializer(Class<Writable> c) {
        return new WritableDeserializer(this.getConf(), c);
    }

    static class WritableSerializer
    extends Configured
    implements Serializer<Writable> {
        private DataOutputStream dataOut;

        WritableSerializer() {
        }

        @Override
        public void open(OutputStream out) {
            this.dataOut = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        }

        @Override
        public void serialize(Writable w) throws IOException {
            w.write(this.dataOut);
        }

        @Override
        public void close() throws IOException {
            this.dataOut.close();
        }
    }

    static class WritableDeserializer
    extends Configured
    implements Deserializer<Writable> {
        private Class<?> writableClass;
        private DataInputStream dataIn;

        public WritableDeserializer(Configuration conf, Class<?> c) {
            this.setConf(conf);
            this.writableClass = c;
        }

        @Override
        public void open(InputStream in) {
            this.dataIn = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        }

        @Override
        public Writable deserialize(Writable w) throws IOException {
            Writable writable = w == null ? (Writable)ReflectionUtils.newInstance(this.writableClass, this.getConf()) : w;
            writable.readFields(this.dataIn);
            return writable;
        }

        @Override
        public void close() throws IOException {
            this.dataIn.close();
        }
    }
}

