/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.ipc;

import java.util.Locale;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.ipc.CostProvider;
import shaded.org.apache.hadoop.ipc.ProcessingDetails;

public class WeightedTimeCostProvider
implements CostProvider {
    public static final String WEIGHT_CONFIG_PREFIX = ".weighted-cost.";
    static final int DEFAULT_LOCKFREE_WEIGHT = 1;
    static final int DEFAULT_LOCKSHARED_WEIGHT = 10;
    static final int DEFAULT_LOCKEXCLUSIVE_WEIGHT = 100;
    private long[] weights;

    @Override
    public void init(String namespace, Configuration conf) {
        this.weights = new long[ProcessingDetails.Timing.values().length];
        for (ProcessingDetails.Timing timing : ProcessingDetails.Timing.values()) {
            int defaultValue;
            switch (timing) {
                case LOCKFREE: 
                case RESPONSE: 
                case HANDLER: {
                    defaultValue = 1;
                    break;
                }
                case LOCKSHARED: {
                    defaultValue = 10;
                    break;
                }
                case LOCKEXCLUSIVE: {
                    defaultValue = 100;
                    break;
                }
                default: {
                    defaultValue = 0;
                }
            }
            String key = namespace + WEIGHT_CONFIG_PREFIX + timing.name().toLowerCase(Locale.ENGLISH);
            this.weights[timing.ordinal()] = conf.getInt(key, defaultValue);
        }
    }

    @Override
    public long getCost(ProcessingDetails details) {
        assert (this.weights != null) : "Cost provider must be initialized before use";
        long cost = 0L;
        for (int i = 0; i < ProcessingDetails.Timing.values().length; ++i) {
            cost += details.get(ProcessingDetails.Timing.values()[i]) * this.weights[i];
        }
        return cost;
    }
}

