/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.ipc.metrics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.metrics2.annotation.Metric;
import shaded.org.apache.hadoop.metrics2.annotation.Metrics;
import shaded.org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import shaded.org.apache.hadoop.metrics2.lib.MetricsRegistry;
import shaded.org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;

@InterfaceAudience.Private
@Metrics(about="Per method RPC metrics", context="rpcdetailed")
public class RpcDetailedMetrics {
    @Metric
    MutableRatesWithAggregation rates;
    @Metric
    MutableRatesWithAggregation deferredRpcRates;
    static final Logger LOG = LoggerFactory.getLogger(RpcDetailedMetrics.class);
    final MetricsRegistry registry;
    final String name;

    RpcDetailedMetrics(int port) {
        this.name = "RpcDetailedActivityForPort" + port;
        this.registry = new MetricsRegistry("rpcdetailed").tag("port", "RPC port", String.valueOf(port));
        LOG.debug(this.registry.info().toString());
    }

    public String name() {
        return this.name;
    }

    public static RpcDetailedMetrics create(int port) {
        RpcDetailedMetrics m = new RpcDetailedMetrics(port);
        return DefaultMetricsSystem.instance().register(m.name, null, m);
    }

    public void init(Class<?> protocol) {
        this.rates.init(protocol);
        this.deferredRpcRates.init(protocol);
    }

    public void addProcessingTime(String rpcCallName, long processingTime) {
        this.rates.add(rpcCallName, processingTime);
    }

    public void addDeferredProcessingTime(String name, long processingTime) {
        this.deferredRpcRates.add(name, processingTime);
    }

    public void shutdown() {
        DefaultMetricsSystem.instance().unregisterSource(this.name);
    }
}

