/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;

class CleanupQueue {
    public static final Log LOG = LogFactory.getLog(CleanupQueue.class);
    private static PathCleanupThread cleanupThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CleanupQueue() {
        Class<PathCleanupThread> clazz = PathCleanupThread.class;
        synchronized (PathCleanupThread.class) {
            if (cleanupThread == null) {
                cleanupThread = new PathCleanupThread();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void addToQueue(PathDeletionContext ... contexts) {
        cleanupThread.addToQueue(contexts);
    }

    protected static boolean deletePath(PathDeletionContext context) throws IOException {
        context.enablePathForCleanup();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to delete " + context.fullPath));
        }
        if (context.fs.exists(new Path(context.fullPath))) {
            return context.fs.delete(new Path(context.fullPath), true);
        }
        return true;
    }

    protected boolean isQueueEmpty() {
        return cleanupThread.queue.size() == 0;
    }

    private static class PathCleanupThread
    extends Thread {
        private LinkedBlockingQueue<PathDeletionContext> queue = new LinkedBlockingQueue();

        public PathCleanupThread() {
            this.setName("Directory/File cleanup thread");
            this.setDaemon(true);
            this.start();
        }

        void addToQueue(PathDeletionContext[] contexts) {
            for (PathDeletionContext context : contexts) {
                try {
                    this.queue.put(context);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + " started."));
            }
            PathDeletionContext context = null;
            while (true) {
                try {
                    while (true) {
                        if (!CleanupQueue.deletePath(context = this.queue.take())) {
                            LOG.warn((Object)("CleanupThread:Unable to delete path " + context.fullPath));
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("DELETED " + context.fullPath));
                    }
                }
                catch (InterruptedException t) {
                    if (context == null) {
                        LOG.warn((Object)"Interrupted deletion of an invalid path: Path deletion context is null.");
                    } else {
                        LOG.warn((Object)("Interrupted deletion of " + context.fullPath));
                    }
                    return;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error deleting path " + context.fullPath + ": " + e));
                    continue;
                }
                break;
            }
        }
    }

    static class PathDeletionContext {
        String fullPath;
        FileSystem fs;

        public PathDeletionContext(FileSystem fs, String fullPath) {
            this.fs = fs;
            this.fullPath = fullPath;
        }

        protected String getPathForCleanup() {
            return this.fullPath;
        }

        protected void enablePathForCleanup() throws IOException {
        }
    }
}

