/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.ipc.RPC;
import shaded.org.apache.hadoop.mapred.NotRunningJob;
import shaded.org.apache.hadoop.mapred.ResourceMgrDelegate;
import shaded.org.apache.hadoop.mapred.TaskCompletionEvent;
import shaded.org.apache.hadoop.mapreduce.Counters;
import shaded.org.apache.hadoop.mapreduce.JobID;
import shaded.org.apache.hadoop.mapreduce.JobStatus;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptID;
import shaded.org.apache.hadoop.mapreduce.TaskReport;
import shaded.org.apache.hadoop.mapreduce.TaskType;
import shaded.org.apache.hadoop.mapreduce.TypeConverter;
import shaded.org.apache.hadoop.mapreduce.v2.LogParams;
import shaded.org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsResponse;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.JobId;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.JobState;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import shaded.org.apache.hadoop.mapreduce.v2.util.MRApps;
import shaded.org.apache.hadoop.net.NetUtils;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.security.authorize.AuthorizationException;
import shaded.org.apache.hadoop.security.token.Token;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationId;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationReport;
import shaded.org.apache.hadoop.yarn.api.records.NodeId;
import shaded.org.apache.hadoop.yarn.api.records.YarnApplicationState;
import shaded.org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import shaded.org.apache.hadoop.yarn.exceptions.YarnException;
import shaded.org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import shaded.org.apache.hadoop.yarn.factories.RecordFactory;
import shaded.org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import shaded.org.apache.hadoop.yarn.ipc.YarnRPC;
import shaded.org.apache.hadoop.yarn.util.ConverterUtils;

public class ClientServiceDelegate {
    private static final Log LOG = LogFactory.getLog(ClientServiceDelegate.class);
    private static final String UNAVAILABLE = "N/A";
    private HashMap<JobState, HashMap<String, NotRunningJob>> notRunningJobs;
    private final Configuration conf;
    private final JobID jobId;
    private final ApplicationId appId;
    private final ResourceMgrDelegate rm;
    private final MRClientProtocol historyServerProxy;
    private MRClientProtocol realProxy = null;
    private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static String UNKNOWN_USER = "Unknown User";
    private String trackingUrl;
    private AtomicBoolean usingAMProxy = new AtomicBoolean(false);
    private int maxClientRetry;
    private boolean amAclDisabledStatusLogged = false;

    public ClientServiceDelegate(Configuration conf, ResourceMgrDelegate rm, JobID jobId, MRClientProtocol historyServerProxy) {
        this.conf = new Configuration(conf);
        this.conf.setInt("ipc.client.connect.max.retries", this.conf.getInt("yarn.app.mapreduce.client-am.ipc.max-retries", 3));
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", this.conf.getInt("yarn.app.mapreduce.client-am.ipc.max-retries-on-timeouts", 3));
        this.rm = rm;
        this.jobId = jobId;
        this.historyServerProxy = historyServerProxy;
        this.appId = TypeConverter.toYarn((JobID)jobId).getAppId();
        this.notRunningJobs = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotRunningJob getNotRunningJob(ApplicationReport applicationReport, JobState state) {
        HashMap<JobState, HashMap<String, NotRunningJob>> hashMap = this.notRunningJobs;
        synchronized (hashMap) {
            String user;
            NotRunningJob notRunningJob;
            HashMap<String, NotRunningJob> map = this.notRunningJobs.get(state);
            if (map == null) {
                map = new HashMap();
                this.notRunningJobs.put(state, map);
            }
            if ((notRunningJob = map.get(user = applicationReport == null ? UNKNOWN_USER : applicationReport.getUser())) == null) {
                notRunningJob = new NotRunningJob(applicationReport, state);
                map.put(user, notRunningJob);
            }
            return notRunningJob;
        }
    }

    private MRClientProtocol getProxy() throws IOException {
        if (this.realProxy != null) {
            return this.realProxy;
        }
        ApplicationReport application = null;
        try {
            application = this.rm.getApplicationReport(this.appId);
        }
        catch (ApplicationNotFoundException e) {
            application = null;
        }
        catch (YarnException e2) {
            throw new IOException(e2);
        }
        if (application != null) {
            this.trackingUrl = application.getTrackingUrl();
        }
        InetSocketAddress serviceAddr = null;
        while (application == null || YarnApplicationState.RUNNING == application.getYarnApplicationState()) {
            if (application == null) {
                LOG.info((Object)("Could not get Job info from RM for job " + this.jobId + ". Redirecting to job history server."));
                return this.checkAndGetHSProxy(null, JobState.NEW);
            }
            try {
                UserGroupInformation newUgi;
                if (application.getHost() == null || "".equals(application.getHost())) {
                    LOG.debug((Object)"AM not assigned to Job. Waiting to get the AM ...");
                    Thread.sleep(2000L);
                    LOG.debug((Object)("Application state is " + (Object)((Object)application.getYarnApplicationState())));
                    application = this.rm.getApplicationReport(this.appId);
                    continue;
                }
                if (UNAVAILABLE.equals(application.getHost())) {
                    if (!this.amAclDisabledStatusLogged) {
                        LOG.info((Object)("Job " + this.jobId + " is running, but the host is unknown." + " Verify user has VIEW_JOB access."));
                        this.amAclDisabledStatusLogged = true;
                    }
                    return this.getNotRunningJob(application, JobState.RUNNING);
                }
                if (!this.conf.getBoolean("mapreduce.job.am-access-disabled", false)) {
                    newUgi = UserGroupInformation.createRemoteUser(UserGroupInformation.getCurrentUser().getUserName());
                    serviceAddr = NetUtils.createSocketAddrForHost(application.getHost(), application.getRpcPort());
                    if (UserGroupInformation.isSecurityEnabled()) {
                        shaded.org.apache.hadoop.yarn.api.records.Token clientToAMToken = application.getClientToAMToken();
                        Token token = ConverterUtils.convertFromYarn((shaded.org.apache.hadoop.yarn.api.records.Token)clientToAMToken, (InetSocketAddress)serviceAddr);
                        newUgi.addToken(token);
                    }
                } else {
                    if (!this.amAclDisabledStatusLogged) {
                        LOG.info((Object)("Network ACL closed to AM for job " + this.jobId + ". Not going to try to reach the AM."));
                        this.amAclDisabledStatusLogged = true;
                    }
                    return this.getNotRunningJob(null, JobState.RUNNING);
                }
                LOG.debug((Object)("Connecting to " + serviceAddr));
                final InetSocketAddress finalServiceAddr = serviceAddr;
                this.realProxy = newUgi.doAs(new PrivilegedExceptionAction<MRClientProtocol>(){

                    @Override
                    public MRClientProtocol run() throws IOException {
                        return ClientServiceDelegate.this.instantiateAMProxy(finalServiceAddr);
                    }
                });
                return this.realProxy;
            }
            catch (IOException e) {
                LOG.info((Object)("Could not connect to " + serviceAddr + ". Waiting for getting the latest AM address..."));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    LOG.warn((Object)"getProxy() call interruped", (Throwable)e1);
                    throw new YarnRuntimeException(e1);
                }
                try {
                    application = this.rm.getApplicationReport(this.appId);
                }
                catch (YarnException e1) {
                    throw new IOException(e1);
                }
                if (application != null) continue;
                LOG.info((Object)("Could not get Job info from RM for job " + this.jobId + ". Redirecting to job history server."));
                return this.checkAndGetHSProxy(null, JobState.RUNNING);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"getProxy() call interruped", (Throwable)e);
                throw new YarnRuntimeException(e);
            }
            catch (YarnException e) {
                throw new IOException(e);
            }
        }
        String user = application.getUser();
        if (user == null) {
            throw new IOException("User is not set in the application report");
        }
        if (application.getYarnApplicationState() == YarnApplicationState.NEW || application.getYarnApplicationState() == YarnApplicationState.NEW_SAVING || application.getYarnApplicationState() == YarnApplicationState.SUBMITTED || application.getYarnApplicationState() == YarnApplicationState.ACCEPTED) {
            this.realProxy = null;
            return this.getNotRunningJob(application, JobState.NEW);
        }
        if (application.getYarnApplicationState() == YarnApplicationState.FAILED) {
            this.realProxy = null;
            return this.getNotRunningJob(application, JobState.FAILED);
        }
        if (application.getYarnApplicationState() == YarnApplicationState.KILLED) {
            this.realProxy = null;
            return this.getNotRunningJob(application, JobState.KILLED);
        }
        if (application.getYarnApplicationState() == YarnApplicationState.FINISHED) {
            LOG.info((Object)("Application state is completed. FinalApplicationStatus=" + application.getFinalApplicationStatus().toString() + ". Redirecting to job history server"));
            this.realProxy = this.checkAndGetHSProxy(application, JobState.SUCCEEDED);
        }
        return this.realProxy;
    }

    private MRClientProtocol checkAndGetHSProxy(ApplicationReport applicationReport, JobState state) {
        if (null == this.historyServerProxy) {
            LOG.warn((Object)"Job History Server is not configured.");
            return this.getNotRunningJob(applicationReport, state);
        }
        return this.historyServerProxy;
    }

    MRClientProtocol instantiateAMProxy(InetSocketAddress serviceAddr) throws IOException {
        LOG.trace((Object)("Connecting to ApplicationMaster at: " + serviceAddr));
        YarnRPC rpc = YarnRPC.create((Configuration)this.conf);
        MRClientProtocol proxy = (MRClientProtocol)rpc.getProxy(MRClientProtocol.class, serviceAddr, this.conf);
        this.usingAMProxy.set(true);
        LOG.trace((Object)("Connected to ApplicationMaster at: " + serviceAddr));
        return proxy;
    }

    private synchronized Object invoke(String method, Class argClass, Object args) throws IOException {
        Method methodOb = null;
        try {
            methodOb = MRClientProtocol.class.getMethod(method, argClass);
        }
        catch (SecurityException e) {
            throw new YarnRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new YarnRuntimeException("Method name mismatch", e);
        }
        this.maxClientRetry = this.conf.getInt("yarn.app.mapreduce.client.max-retries", 3);
        IOException lastException = null;
        while (this.maxClientRetry > 0) {
            MRClientProtocol MRClientProxy = null;
            try {
                MRClientProxy = this.getProxy();
                return methodOb.invoke((Object)MRClientProxy, args);
            }
            catch (InvocationTargetException e) {
                LOG.debug((Object)("Failed to contact AM/History for job " + this.jobId + " retrying.."), e.getTargetException());
                this.realProxy = null;
                if (e.getCause() instanceof AuthorizationException) {
                    throw new IOException(e.getTargetException());
                }
                if (!this.usingAMProxy.get()) {
                    --this.maxClientRetry;
                }
                this.usingAMProxy.set(false);
                lastException = new IOException(e.getTargetException());
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)"ClientServiceDelegate invoke call interrupted", (Throwable)ie);
                    throw new YarnRuntimeException(ie);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Failed to contact AM/History for job " + this.jobId + "  Will retry.."), (Throwable)e);
                this.realProxy = null;
                --this.maxClientRetry;
                lastException = new IOException(e.getMessage());
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)"ClientServiceDelegate invoke call interrupted", (Throwable)ie);
                    throw new YarnRuntimeException(ie);
                }
            }
        }
        throw lastException;
    }

    @VisibleForTesting
    public int getMaxClientRetry() {
        return this.maxClientRetry;
    }

    public Counters getJobCounters(JobID arg0) throws IOException, InterruptedException {
        JobId jobID = TypeConverter.toYarn((JobID)arg0);
        GetCountersRequest request = this.recordFactory.newRecordInstance(GetCountersRequest.class);
        request.setJobId(jobID);
        shaded.org.apache.hadoop.mapreduce.v2.api.records.Counters cnt = ((GetCountersResponse)this.invoke("getCounters", GetCountersRequest.class, request)).getCounters();
        return TypeConverter.fromYarn((shaded.org.apache.hadoop.mapreduce.v2.api.records.Counters)cnt);
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(JobID arg0, int arg1, int arg2) throws IOException, InterruptedException {
        JobId jobID = TypeConverter.toYarn((JobID)arg0);
        GetTaskAttemptCompletionEventsRequest request = this.recordFactory.newRecordInstance(GetTaskAttemptCompletionEventsRequest.class);
        request.setJobId(jobID);
        request.setFromEventId(arg1);
        request.setMaxEvents(arg2);
        List list = ((GetTaskAttemptCompletionEventsResponse)this.invoke("getTaskAttemptCompletionEvents", GetTaskAttemptCompletionEventsRequest.class, request)).getCompletionEventList();
        return TypeConverter.fromYarn((TaskAttemptCompletionEvent[])list.toArray(new TaskAttemptCompletionEvent[0]));
    }

    public String[] getTaskDiagnostics(TaskAttemptID arg0) throws IOException, InterruptedException {
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)arg0);
        GetDiagnosticsRequest request = this.recordFactory.newRecordInstance(GetDiagnosticsRequest.class);
        request.setTaskAttemptId(attemptID);
        List list = ((GetDiagnosticsResponse)this.invoke("getDiagnostics", GetDiagnosticsRequest.class, request)).getDiagnosticsList();
        String[] result = new String[list.size()];
        int i = 0;
        for (String c : list) {
            result[i++] = c.toString();
        }
        return result;
    }

    public JobStatus getJobStatus(JobID oldJobID) throws IOException {
        JobId jobId = TypeConverter.toYarn((JobID)oldJobID);
        GetJobReportRequest request = this.recordFactory.newRecordInstance(GetJobReportRequest.class);
        request.setJobId(jobId);
        JobReport report = ((GetJobReportResponse)this.invoke("getJobReport", GetJobReportRequest.class, request)).getJobReport();
        JobStatus jobStatus = null;
        if (report != null) {
            String historyTrackingUrl;
            if (StringUtils.isEmpty((String)report.getJobFile())) {
                String jobFile = MRApps.getJobFile((Configuration)this.conf, (String)report.getUser(), (JobID)oldJobID);
                report.setJobFile(jobFile);
            }
            String url = StringUtils.isNotEmpty((String)(historyTrackingUrl = report.getTrackingUrl())) ? historyTrackingUrl : this.trackingUrl;
            jobStatus = TypeConverter.fromYarn((JobReport)report, (String)url);
        }
        return jobStatus;
    }

    public TaskReport[] getTaskReports(JobID oldJobID, TaskType taskType) throws IOException {
        JobId jobId = TypeConverter.toYarn((JobID)oldJobID);
        GetTaskReportsRequest request = this.recordFactory.newRecordInstance(GetTaskReportsRequest.class);
        request.setJobId(jobId);
        request.setTaskType(TypeConverter.toYarn((TaskType)taskType));
        List taskReports = ((GetTaskReportsResponse)this.invoke("getTaskReports", GetTaskReportsRequest.class, request)).getTaskReportList();
        return TypeConverter.fromYarn((List)taskReports).toArray(new TaskReport[0]);
    }

    public boolean killTask(TaskAttemptID taskAttemptID, boolean fail) throws IOException {
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        if (fail) {
            FailTaskAttemptRequest failRequest = this.recordFactory.newRecordInstance(FailTaskAttemptRequest.class);
            failRequest.setTaskAttemptId(attemptID);
            this.invoke("failTaskAttempt", FailTaskAttemptRequest.class, failRequest);
        } else {
            KillTaskAttemptRequest killRequest = this.recordFactory.newRecordInstance(KillTaskAttemptRequest.class);
            killRequest.setTaskAttemptId(attemptID);
            this.invoke("killTaskAttempt", KillTaskAttemptRequest.class, killRequest);
        }
        return true;
    }

    public boolean killJob(JobID oldJobID) throws IOException {
        JobId jobId = TypeConverter.toYarn((JobID)oldJobID);
        KillJobRequest killRequest = this.recordFactory.newRecordInstance(KillJobRequest.class);
        killRequest.setJobId(jobId);
        this.invoke("killJob", KillJobRequest.class, killRequest);
        return true;
    }

    public LogParams getLogFilePath(JobID oldJobID, TaskAttemptID oldTaskAttemptID) throws IOException {
        JobId jobId = TypeConverter.toYarn((JobID)oldJobID);
        GetJobReportRequest request = this.recordFactory.newRecordInstance(GetJobReportRequest.class);
        request.setJobId(jobId);
        JobReport report = ((GetJobReportResponse)this.invoke("getJobReport", GetJobReportRequest.class, request)).getJobReport();
        if (EnumSet.of(JobState.SUCCEEDED, JobState.FAILED, JobState.KILLED, JobState.ERROR).contains(report.getJobState())) {
            if (oldTaskAttemptID != null) {
                GetTaskAttemptReportRequest taRequest = this.recordFactory.newRecordInstance(GetTaskAttemptReportRequest.class);
                taRequest.setTaskAttemptId(TypeConverter.toYarn((TaskAttemptID)oldTaskAttemptID));
                TaskAttemptReport taReport = ((GetTaskAttemptReportResponse)this.invoke("getTaskAttemptReport", GetTaskAttemptReportRequest.class, taRequest)).getTaskAttemptReport();
                if (taReport.getContainerId() == null || taReport.getNodeManagerHost() == null) {
                    throw new IOException("Unable to get log information for task: " + oldTaskAttemptID);
                }
                return new LogParams(taReport.getContainerId().toString(), taReport.getContainerId().getApplicationAttemptId().getApplicationId().toString(), NodeId.newInstance(taReport.getNodeManagerHost(), taReport.getNodeManagerPort()).toString(), report.getUser());
            }
            if (report.getAMInfos() == null || report.getAMInfos().size() == 0) {
                throw new IOException("Unable to get log information for job: " + oldJobID);
            }
            AMInfo amInfo = (AMInfo)report.getAMInfos().get(report.getAMInfos().size() - 1);
            return new LogParams(amInfo.getContainerId().toString(), amInfo.getAppAttemptId().getApplicationId().toString(), NodeId.newInstance(amInfo.getNodeManagerHost(), amInfo.getNodeManagerPort()).toString(), report.getUser());
        }
        throw new IOException("Cannot get log path for a in-progress job");
    }

    public void close() throws IOException {
        if (this.rm != null) {
            this.rm.close();
        }
        if (this.historyServerProxy != null) {
            RPC.stopProxy(this.historyServerProxy);
        }
        if (this.realProxy != null) {
            RPC.stopProxy(this.realProxy);
            this.realProxy = null;
        }
    }
}

