/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.mapred.MapTask;
import shaded.org.apache.hadoop.mapred.ReduceTask;
import shaded.org.apache.hadoop.mapred.Task;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JvmTask
implements Writable {
    Task t;
    boolean shouldDie;

    public JvmTask(Task t, boolean shouldDie) {
        this.t = t;
        this.shouldDie = shouldDie;
    }

    public JvmTask() {
    }

    public Task getTask() {
        return this.t;
    }

    public boolean shouldDie() {
        return this.shouldDie;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.shouldDie);
        if (this.t != null) {
            out.writeBoolean(true);
            out.writeBoolean(this.t.isMapTask());
            this.t.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.shouldDie = in.readBoolean();
        boolean taskComing = in.readBoolean();
        if (taskComing) {
            boolean isMap = in.readBoolean();
            this.t = isMap ? new MapTask() : new ReduceTask();
            this.t.readFields(in);
        }
    }
}

